/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.math.BigDecimal;

public class PaymentResponse
extends AggregatedEntity {
    private int code;
    private int fid;
    private BigDecimal amount;
    private String title;
    private String orderno;
    private int payway;
    private int paytype;
    private String remark;
    private String payinfo;

    public PaymentResponse() {
        super(new AggregatedMark(true, false));
    }

    public PaymentResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.int2HexWithPush(this.code, 4)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.a_text(this.title)).append(ByteUtils.a_text(this.orderno)).append(ByteUtils.int2Hex(this.payway)).append(ByteUtils.int2Hex(this.paytype)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.a_text(this.payinfo));
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        int index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.payway = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.paytype = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.payinfo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOrderno() {
        return this.orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public int getPayway() {
        return this.payway;
    }

    public void setPayway(int payway) {
        this.payway = payway;
    }

    public int getPaytype() {
        return this.paytype;
    }

    public void setPaytype(int paytype) {
        this.paytype = paytype;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPayinfo() {
        return this.payinfo;
    }

    public void setPayinfo(String payinfo) {
        this.payinfo = payinfo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

