/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.cloudpay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Date;

public class RefundRequest
extends AggregatedEntity {
    private int balanceId;
    private int orderFid;
    private String orderNo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date orderTime;
    private int fid;
    private int sid;
    private int scaleMan;
    private BigDecimal amount;
    private int random = RandomUtils.integer_random(65535);
    private String remark;
    private int autoLog;

    public RefundRequest() {
        super(new AggregatedMark(true, true));
    }

    public RefundRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.fid(this.balanceId)).append(ByteUtils.fid(this.orderFid)).append(ByteUtils.a_text(this.orderNo)).append(ByteUtils.timeToStrNone(this.orderTime)).append(ByteUtils.fid(this.fid)).append(ByteUtils.fid(this.sid)).append(ByteUtils.int2Hex(this.scaleMan)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.int2Hex(this.autoLog));
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.balanceId = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.orderFid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        int index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.orderTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.sid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.scaleMan = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.autoLog = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public int getBalanceId() {
        return this.balanceId;
    }

    public void setBalanceId(int balanceId) {
        this.balanceId = balanceId;
    }

    public int getOrderFid() {
        return this.orderFid;
    }

    public void setOrderFid(int orderFid) {
        this.orderFid = orderFid;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getOrderTime() {
        return this.orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getScaleMan() {
        return this.scaleMan;
    }

    public void setScaleMan(int scaleMan) {
        this.scaleMan = scaleMan;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String orderFid() {
        return ByteUtils.fid(this.orderFid);
    }

    public int getAutoLog() {
        return this.autoLog;
    }

    public void setAutoLog(int autoLog) {
        this.autoLog = autoLog;
    }
}

