/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.cloudpay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.math.BigDecimal;
import java.util.Date;

public class RefundResponse
extends AggregatedEntity {
    private int code;
    private int fid;
    private BigDecimal amount;
    private String orderno;
    private String refundno;
    private String retrunno;
    private int payway;
    private String remark;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expire;
    private String errCode;
    private String errMsg;

    public RefundResponse() {
        super(new AggregatedMark(true, false));
    }

    public RefundResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.int2HexWithPush(this.code, 4)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.a_text(this.orderno)).append(ByteUtils.a_text(this.refundno)).append(ByteUtils.a_text(this.retrunno)).append(ByteUtils.int2Hex(this.payway)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.timeToStrNone(this.expire)).append(ByteUtils.a_text(this.errCode)).append(ByteUtils.a_text(this.errMsg));
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        int index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.refundno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.retrunno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.payway = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getOrderno() {
        return this.orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public String getRefundno() {
        return this.refundno;
    }

    public void setRefundno(String refundno) {
        this.refundno = refundno;
    }

    public String getRetrunno() {
        return this.retrunno;
    }

    public void setRetrunno(String retrunno) {
        this.retrunno = retrunno;
    }

    public int getPayway() {
        return this.payway;
    }

    public void setPayway(int payway) {
        this.payway = payway;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}

