/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum HandleState {
    SUCCESS(0, "OK", "\u652f\u4ed8\u6210\u529f"),
    FAIL(1, "NO", "\u652f\u4ed8\u5931\u8d25"),
    WAIT(2, "WT", "\u652f\u4ed8\u7b49\u5f85"),
    PAY_TIMEOUT(3, "PT", "\u652f\u8d85\u65f6 "),
    BUILD_CREATE(4, "BC", "\u521b\u5efa\u652f\u4ed8"),
    CLOSE(5, "CE", "\u8ba2\u5355\u5173\u95ed"),
    CANCEL(6, "CL", "\u8ba2\u5355\u64a4\u9500"),
    REMOVE(7, "RM", "\u8ba2\u5355\u53d6\u6d88");

    private final int code;
    private final String state;
    private final String description;

    private HandleState(int code, String state, String description) {
        this.code = code;
        this.state = state;
        this.description = description;
    }

    public static HandleState code(int code) {
        for (HandleState value : HandleState.values()) {
            if (value.code != code) continue;
            return value;
        }
        return null;
    }

    public static HandleState state(String state) {
        if (StringUtils.isNotBlank((CharSequence)state)) {
            for (HandleState value : HandleState.values()) {
                if (!value.getState().equals(state)) continue;
                return value;
            }
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "HandleState{code=" + this.code + ", state='" + this.state + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

