/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum QRState {
    NEW_CODE(0, "NEW_CODE", "\u5f85\u626b\u7801"),
    REPLACED(1, "REPLACED", "\u5df2\u66ff\u6362"),
    INVALID(2, "INVALID", "\u5df2\u5931\u6548"),
    SCANNED(3, "SCANNED", "\u5df2\u626b\u7801"),
    SUCCESS(4, "SUCCESS", "\u5b8c\u6210\u626b\u7801"),
    FAIL(5, "FAIL", "\u626b\u7801\u5931\u8d25");

    private final int code;
    private final String state;
    private final String description;

    private QRState(int code, String type, String description) {
        this.code = code;
        this.state = type;
        this.description = description;
    }

    public static QRState code(int state) {
        for (QRState value : QRState.values()) {
            if (value.code != state) continue;
            return value;
        }
        return null;
    }

    public static QRState state(String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        for (QRState value : QRState.values()) {
            if (!value.state.equals(state)) continue;
            return value;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "QRState{code=" + this.code + ", type='" + this.state + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

