/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.em;

import com.jhscale.common.model.device.polymerization.em.ReasonType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum Reason {
    \u5ba2\u6237\u4e3b\u52a8\u9000\u6b3e(101, ReasonType.\u9000\u6b3e, "custom_refund", "\u5ba2\u6237\u4e3b\u52a8\u9000\u6b3e"),
    \u5546\u5bb6\u4e3b\u52a8\u9000\u6b3e(102, ReasonType.\u9000\u6b3e, "merchant_refund", "\u5546\u5bb6\u4e3b\u52a8\u9000\u6b3e"),
    \u5ba2\u6237\u4e3b\u52a8\u6ce8\u9500(201, ReasonType.\u6ce8\u9500, "custom_cancel", "\u5ba2\u6237\u4e3b\u52a8\u6ce8\u9500"),
    \u5546\u5bb6\u4e3b\u52a8\u6ce8\u9500(202, ReasonType.\u6ce8\u9500, "merchant_cancel", "\u5546\u5bb6\u4e3b\u52a8\u6ce8\u9500");

    private final int no;
    private final ReasonType type;
    private final String addr;
    private final String description;

    private Reason(int no, ReasonType type, String addr, String description) {
        this.no = no;
        this.type = type;
        this.addr = addr;
        this.description = description;
    }

    public static Reason no(int no) {
        for (Reason value : Reason.values()) {
            if (value.no != no) continue;
            return value;
        }
        return null;
    }

    public static Reason addr(String addr) {
        if (StringUtils.isNotBlank((CharSequence)addr)) {
            for (Reason value : Reason.values()) {
                if (!value.addr.equals(addr)) continue;
                return value;
            }
        }
        return null;
    }

    public static List<Reason> type(ReasonType type) {
        if (type != null) {
            ArrayList<Reason> reasons = null;
            for (Reason value : Reason.values()) {
                if (!value.type.equals((Object)type)) continue;
                if (reasons == null) {
                    reasons = new ArrayList<Reason>();
                }
                reasons.add(value);
            }
            return reasons;
        }
        return null;
    }

    public int getNo() {
        return this.no;
    }

    public ReasonType getType() {
        return this.type;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getDescription() {
        return this.description;
    }
}

