/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.inner;

import com.jhscale.common.model.device.polymerization.inner.POSCombination;
import com.jhscale.common.utils.ByteUtils;

public class AggregatedMark
implements POSCombination {
    private String hex;
    private String binary;
    private boolean encrypt;
    private boolean ack;
    private int cd;
    private int len;

    public AggregatedMark() {
    }

    public AggregatedMark(boolean encrypt, boolean ack) {
        this.encrypt = encrypt;
        this.ack = ack;
    }

    public AggregatedMark(String hex) {
        this.hex = hex;
    }

    @Override
    public void assemble(String aesKey) {
        String binaryString = Integer.toBinaryString(this.len / 2);
        binaryString = binaryString.length() % 2 == 0 ? binaryString : "0" + binaryString;
        StringBuilder builder = new StringBuilder();
        builder.append(this.encrypt ? (char)'1' : '0').append(this.ack ? (char)'1' : '0').append("00").append(ByteUtils.appendFill(Integer.toBinaryString(this.cd), 2)).append(binaryString);
        this.binary = builder.toString();
        this.hex = ByteUtils.binaryToHex(this.binary);
    }

    @Override
    public boolean analyse(String aesKey) {
        this.binary = ByteUtils.formatMark(this.hex);
        this.encrypt = '1' == this.binary.charAt(0);
        this.ack = '1' == this.binary.charAt(1);
        this.cd = Integer.parseInt(this.binary.substring(4, 6), 2);
        this.len = Integer.parseInt(this.binary.substring(6, 8), 2) * 2;
        return false;
    }

    public String getHex() {
        return this.hex;
    }

    public AggregatedMark setHex(String hex) {
        this.hex = hex;
        return this;
    }

    public String getBinary() {
        return this.binary;
    }

    public AggregatedMark setBinary(String binary) {
        this.binary = binary;
        return this;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public AggregatedMark setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public boolean isAck() {
        return this.ack;
    }

    public AggregatedMark setAck(boolean ack) {
        this.ack = ack;
        return this;
    }

    public int getCd() {
        return this.cd;
    }

    public AggregatedMark setCd(int cd) {
        this.cd = cd;
        return this;
    }

    public int getLen() {
        return this.len;
    }

    public AggregatedMark setLen(int len) {
        this.len = len;
        return this;
    }
}

