/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.inner;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.utils.ByteUtils;
import java.math.BigDecimal;
import java.util.Date;

public class JKYRechargeSetMeal
extends AggregatedEntity {
    private String kid;
    private String name;
    private int mealOrder;
    private int grade;
    private BigDecimal rechargeAmount;
    private BigDecimal donationAmount;
    private String takeChargeFee;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date donationExpireTime;

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.kid)).append(ByteUtils.a_text(this.name)).append(ByteUtils.int2HexWithPush(this.mealOrder, 8)).append(ByteUtils.int2Hex(this.grade)).append(ByteUtils.toSPFStrNone(this.rechargeAmount)).append(ByteUtils.toSPFStrNone(this.donationAmount)).append(ByteUtils.a_text(this.takeChargeFee)).append(ByteUtils.timeToStr(this.donationExpireTime));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.kid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.name = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.grade = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.rechargeAmount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.donationAmount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.takeChargeFee = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.donationExpireTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        return innerContent;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMealOrder() {
        return this.mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public BigDecimal getRechargeAmount() {
        return this.rechargeAmount;
    }

    public void setRechargeAmount(BigDecimal rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public BigDecimal getDonationAmount() {
        return this.donationAmount;
    }

    public void setDonationAmount(BigDecimal donationAmount) {
        this.donationAmount = donationAmount;
    }

    public String getTakeChargeFee() {
        return this.takeChargeFee;
    }

    public void setTakeChargeFee(String takeChargeFee) {
        this.takeChargeFee = takeChargeFee;
    }

    public Date getDonationExpireTime() {
        return this.donationExpireTime;
    }

    public void setDonationExpireTime(Date donationExpireTime) {
        this.donationExpireTime = donationExpireTime;
    }
}

