/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.em.SwitchState;
import com.jhscale.common.model.device.polymerization.em.TradeEnv;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.StringUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class JKYLoginResponse
extends AggregatedEntity {
    private String lockId;
    private int code;
    private String errCode;
    private String errMsg;
    private String type;
    private String card;
    private int tradeEnv;
    private int level;
    private String specialType;
    private BigDecimal discount;
    private BigDecimal balance;
    private BigDecimal giveBalance;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date giveBalanceTime;
    private BigDecimal integral;
    private String cardKid;
    private String operatorMobile;
    private String operatorPic;
    private Integer enableCash;
    private Integer enableIntegral;
    private Integer enableBlend;
    private Integer enablePhone;
    private BigDecimal phoneFreePay;

    public JKYLoginResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYLoginResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2HexWithPush(this.code, 4)).append(ByteUtils.toHexString(new byte[]{(byte)this.type.charAt(0)})).append(ByteUtils.a_text(this.card)).append(ByteUtils.a_text(this.errCode)).append(ByteUtils.a_text(this.errMsg));
        TradeEnv env = TradeEnv.status(this.tradeEnv);
        if (Objects.nonNull((Object)env)) {
            builder.append(ByteUtils.int2Hex(this.tradeEnv)).append(ByteUtils.int2Hex(this.level)).append(ByteUtils.a_text(this.specialType)).append(ByteUtils.toSPFStrNone(this.discount)).append(ByteUtils.toSPFStrNone(this.balance)).append(ByteUtils.toSPFStrNone(this.giveBalance)).append(ByteUtils.timeToStrNone(this.giveBalanceTime)).append(ByteUtils.toSPFStrNone(this.integral)).append(ByteUtils.a_text(this.cardKid)).append(ByteUtils.a_text(this.operatorMobile)).append(ByteUtils.a_text(this.operatorPic));
            String enable = "0000000000000000";
            if (SwitchState.\u542f\u7528.equals((Object)SwitchState.switchState(this.enableCash))) {
                enable = StringUtil.replace(enable, 0, '1');
            }
            if (SwitchState.\u542f\u7528.equals((Object)SwitchState.switchState(this.enableIntegral))) {
                enable = StringUtil.replace(enable, 1, '1');
            }
            if (SwitchState.\u542f\u7528.equals((Object)SwitchState.switchState(this.enableBlend))) {
                enable = StringUtil.replace(enable, 2, '1');
            }
            if (SwitchState.\u542f\u7528.equals((Object)SwitchState.switchState(this.enablePhone))) {
                enable = StringUtil.replace(enable, 3, '1');
            }
            builder.append(ByteUtils.binaryToHex(enable, 4)).append(ByteUtils.toSPFStrNone(this.phoneFreePay));
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.type = new String(ByteUtils.fromHexString(innerContent.substring(0, 2)));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
        if (index != -1) {
            this.card = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.tradeEnv = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        TradeEnv env = TradeEnv.status(this.tradeEnv);
        if (Objects.nonNull((Object)env)) {
            this.level = ByteUtils.hex2Ten(innerContent.substring(0, 2));
            index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
            if (index != -1) {
                this.specialType = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }
            this.discount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
            this.balance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
            this.giveBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
            this.giveBalanceTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
            this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
            if (index != -1) {
                this.cardKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }
            if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
                this.operatorMobile = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }
            if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
                this.operatorPic = ByteUtils.p_text(innerContent.substring(0, index + 2));
                innerContent = innerContent.substring(index + 2);
            }
            String binary = ByteUtils.hexToBinary(innerContent.substring(0, 4), 16);
            innerContent = innerContent.substring(4);
            this.enableCash = SwitchState.switchState(binary.charAt(0)).enable();
            this.enableIntegral = SwitchState.switchState(binary.charAt(1)).enable();
            this.enableBlend = SwitchState.switchState(binary.charAt(2)).enable();
            this.enablePhone = SwitchState.switchState(binary.charAt(3)).enable();
            this.phoneFreePay = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
            innerContent = innerContent.substring(8);
        }
        return innerContent;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ONE;
    }

    public BigDecimal balance() {
        return Objects.nonNull(this.balance) ? this.balance : BigDecimal.ZERO;
    }

    public BigDecimal giveBalance() {
        return Objects.nonNull(this.giveBalance) ? this.giveBalance : BigDecimal.ZERO;
    }

    public Date giveBalanceTime() {
        return Objects.nonNull(this.giveBalanceTime) ? this.giveBalanceTime : new Date(DateUtils.TIME_2000_1_1_0_0_0);
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public BigDecimal phoneFreePay() {
        return Objects.nonNull(this.phoneFreePay) ? this.phoneFreePay : BigDecimal.ZERO;
    }

    public BigDecimal getTotalBalance() {
        return this.balance().add(this.giveBalance());
    }

    public boolean isGiveForever() {
        return ByteUtils.isGiveForever(this.giveBalance, this.giveBalanceTime);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getTradeEnv() {
        return this.tradeEnv;
    }

    public void setTradeEnv(int tradeEnv) {
        this.tradeEnv = tradeEnv;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(String specialType) {
        this.specialType = specialType;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getGiveBalance() {
        return this.giveBalance;
    }

    public void setGiveBalance(BigDecimal giveBalance) {
        this.giveBalance = giveBalance;
    }

    public Date getGiveBalanceTime() {
        return this.giveBalanceTime;
    }

    public void setGiveBalanceTime(Date giveBalanceTime) {
        this.giveBalanceTime = giveBalanceTime;
    }

    public BigDecimal getIntegral() {
        return this.integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public String getCardKid() {
        return this.cardKid;
    }

    public void setCardKid(String cardKid) {
        this.cardKid = cardKid;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getOperatorMobile() {
        return this.operatorMobile;
    }

    public void setOperatorMobile(String operatorMobile) {
        this.operatorMobile = operatorMobile;
    }

    public String getOperatorPic() {
        return this.operatorPic;
    }

    public void setOperatorPic(String operatorPic) {
        this.operatorPic = operatorPic;
    }

    public Integer getEnableCash() {
        return this.enableCash;
    }

    public void setEnableCash(Integer enableCash) {
        this.enableCash = enableCash;
    }

    public Integer getEnableIntegral() {
        return this.enableIntegral;
    }

    public void setEnableIntegral(Integer enableIntegral) {
        this.enableIntegral = enableIntegral;
    }

    public Integer getEnableBlend() {
        return this.enableBlend;
    }

    public void setEnableBlend(Integer enableBlend) {
        this.enableBlend = enableBlend;
    }

    public Integer getEnablePhone() {
        return this.enablePhone;
    }

    public void setEnablePhone(Integer enablePhone) {
        this.enablePhone = enablePhone;
    }

    public BigDecimal getPhoneFreePay() {
        return this.phoneFreePay;
    }

    public void setPhoneFreePay(BigDecimal phoneFreePay) {
        this.phoneFreePay = phoneFreePay;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}

