/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.JKYIntegralSetMeal;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;

public class JKYIntegralSetMealResponse
extends AggregatedEntity {
    private int mealVersion;
    private List<JKYIntegralSetMeal> setMeals;

    public JKYIntegralSetMealResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYIntegralSetMealResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder().append(ByteUtils.int2HexWithPush(this.mealVersion, 8));
        if (this.setMeals != null && !this.setMeals.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.setMeals.size()));
            for (JKYIntegralSetMeal setMeal : this.setMeals) {
                builder.append((CharSequence)setMeal.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.setMeals = new ArrayList<JKYIntegralSetMeal>();
            for (int i = 0; i < size; ++i) {
                JKYIntegralSetMeal setMeal = new JKYIntegralSetMeal();
                innerContent = setMeal.inner_analyse(innerContent);
                this.setMeals.add(setMeal);
            }
        }
        return innerContent;
    }

    public int getMealVersion() {
        return this.mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public List<JKYIntegralSetMeal> getSetMeals() {
        return this.setMeals;
    }

    public void setSetMeals(List<JKYIntegralSetMeal> setMeals) {
        this.setMeals = setMeals;
    }
}

