/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.JKYRechargeSetMeal;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.model.device.polymerization.jky.biz.JKYSettingListResponse;
import com.jhscale.common.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JKYRechargeSetMealResponse
extends AggregatedEntity {
    private int mealVersion;
    private List<JKYRechargeSetMeal> setMeals;
    private JKYSettingListResponse settingList;

    public JKYRechargeSetMealResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYRechargeSetMealResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder().append(ByteUtils.int2HexWithPush(this.mealVersion, 8));
        if (this.setMeals != null && !this.setMeals.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.setMeals.size()));
            for (JKYRechargeSetMeal setMeal : this.setMeals) {
                builder.append((CharSequence)setMeal.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        if (Objects.nonNull(this.settingList)) {
            builder.append((CharSequence)this.settingList.inner_assembly());
        }
        return builder;
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.setMeals = new ArrayList<JKYRechargeSetMeal>();
            for (int i = 0; i < size; ++i) {
                JKYRechargeSetMeal setMeal = new JKYRechargeSetMeal();
                innerContent = setMeal.inner_analyse(innerContent);
                this.setMeals.add(setMeal);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)innerContent)) {
            JKYSettingListResponse settingList = new JKYSettingListResponse();
            innerContent = settingList.inner_analyse(innerContent);
            this.settingList = settingList;
        }
        return innerContent;
    }

    public int getMealVersion() {
        return this.mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public List<JKYRechargeSetMeal> getSetMeals() {
        return this.setMeals;
    }

    public void setSetMeals(List<JKYRechargeSetMeal> setMeals) {
        this.setMeals = setMeals;
    }

    public JKYSettingListResponse getSettingList() {
        return this.settingList;
    }

    public void setSettingList(JKYSettingListResponse settingList) {
        this.settingList = settingList;
    }
}

