/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.biz;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.JKYDiscountLevel;
import com.jhscale.common.model.device.polymerization.inner.JKYMerchantSetting;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JKYSettingListResponse
extends AggregatedEntity {
    private long merchantSign;
    private String merchantKid;
    private List<JKYMerchantSetting> settingList;
    private List<JKYDiscountLevel> levelList;
    private Map<String, String> otherParams;

    public JKYSettingListResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYSettingListResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder();
        builder.append(ByteUtils.long2Hex(this.merchantSign, 16)).append(ByteUtils.a_text(this.merchantKid));
        if (this.settingList != null && !this.settingList.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.settingList.size()));
            for (JKYMerchantSetting jKYMerchantSetting : this.settingList) {
                builder.append((CharSequence)jKYMerchantSetting.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        if (this.levelList != null && !this.levelList.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.levelList.size()));
            for (JKYDiscountLevel jKYDiscountLevel : this.levelList) {
                builder.append((CharSequence)jKYDiscountLevel.inner_assembly());
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        if (this.otherParams != null && !this.otherParams.isEmpty()) {
            builder.append(ByteUtils.int2Hex(this.otherParams.size()));
            for (Map.Entry entry : this.otherParams.entrySet()) {
                builder.append(ByteUtils.a_text((String)entry.getKey())).append(ByteUtils.a_text((String)entry.getValue()));
            }
        } else {
            builder.append(ByteUtils.int2Hex(0));
        }
        return builder;
    }

    @Override
    public String inner_analyse(String innerContent) {
        int i;
        this.merchantSign = ByteUtils.hex2Long(innerContent.substring(0, 16));
        int index = ByteUtils.indexOf(innerContent = innerContent.substring(16), "00");
        if (index != -1) {
            this.merchantKid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        int size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.settingList = new ArrayList<JKYMerchantSetting>();
            for (i = 0; i < size; ++i) {
                JKYMerchantSetting setting = new JKYMerchantSetting();
                innerContent = setting.inner_analyse(innerContent);
                this.settingList.add(setting);
            }
        }
        size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.levelList = new ArrayList<JKYDiscountLevel>();
            for (i = 0; i < size; ++i) {
                JKYDiscountLevel level = new JKYDiscountLevel();
                innerContent = level.inner_analyse(innerContent);
                this.levelList.add(level);
            }
        }
        size = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        if (size > 0) {
            this.otherParams = new HashMap<String, String>();
            for (i = 0; i < size; ++i) {
                String key = null;
                String value = null;
                index = ByteUtils.indexOf(innerContent, "00");
                if (index != -1) {
                    key = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }
                if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
                    value = ByteUtils.p_text(innerContent.substring(0, index + 2));
                    innerContent = innerContent.substring(index + 2);
                }
                this.otherParams.put(key, value);
            }
        }
        return innerContent;
    }

    public long getMerchantSign() {
        return this.merchantSign;
    }

    public void setMerchantSign(long merchantSign) {
        this.merchantSign = merchantSign;
    }

    public String getMerchantKid() {
        return this.merchantKid;
    }

    public void setMerchantKid(String merchantKid) {
        this.merchantKid = merchantKid;
    }

    public List<JKYMerchantSetting> getSettingList() {
        return this.settingList;
    }

    public void setSettingList(List<JKYMerchantSetting> settingList) {
        this.settingList = settingList;
    }

    public List<JKYDiscountLevel> getLevelList() {
        return this.levelList;
    }

    public void setLevelList(List<JKYDiscountLevel> levelList) {
        this.levelList = levelList;
    }

    public Map<String, String> getOtherParams() {
        return this.otherParams;
    }

    public void setOtherParams(Map<String, String> otherParams) {
        this.otherParams = otherParams;
    }
}

