/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Objects;

public class JKYIntegralRequest
extends AggregatedEntity {
    private String lockId;
    private int fid;
    private int type;
    private int mealVersion;
    private int mealOrder;
    private BigDecimal integral;
    private String remark;
    private int random = RandomUtils.integer_random(65535);
    private int count = 1;
    private int retryCount;

    public JKYIntegralRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYIntegralRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.int2Hex(this.type)).append(ByteUtils.int2HexWithPush(this.mealVersion, 8)).append(ByteUtils.int2HexWithPush(this.mealOrder, 8)).append(ByteUtils.toSPFStrNone(this.integral)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.int2Hex(this.count)).append(ByteUtils.int2Hex(this.retryCount));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.type = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMealVersion() {
        return this.mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public int getMealOrder() {
        return this.mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public BigDecimal getIntegral() {
        return this.integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

