/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class JKYIntegralResponse
extends AggregatedEntity {
    private String lockId;
    private int code;
    private int fid;
    private String orderNo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expire;
    private String errCode;
    private String errMsg;
    private int tradeType;
    private BigDecimal integral;
    private BigDecimal beforeBalance;
    private BigDecimal beforeGiveMoney;
    private BigDecimal beforeIntegral;
    private BigDecimal afterBalance;
    private BigDecimal afterGiveMoney;
    private BigDecimal afterIntegral;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date giveBalanceTime;
    private String description;

    public JKYIntegralResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYIntegralResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2Hex(this.code)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.a_text(this.orderNo)).append(ByteUtils.timeToStrNone(this.expire)).append(ByteUtils.a_text(this.errCode)).append(ByteUtils.a_text(this.errMsg)).append(ByteUtils.int2Hex(this.tradeType)).append(ByteUtils.toSPFStrNone(this.integral)).append(ByteUtils.toSPFStrNone(this.beforeBalance)).append(ByteUtils.toSPFStrNone(this.beforeGiveMoney)).append(ByteUtils.toSPFStrNone(this.beforeIntegral)).append(ByteUtils.toSPFStrNone(this.afterBalance)).append(ByteUtils.toSPFStrNone(this.afterGiveMoney)).append(ByteUtils.toSPFStrNone(this.afterIntegral)).append(ByteUtils.timeToStrNone(this.giveBalanceTime)).append(ByteUtils.a_text(this.description));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.beforeBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.beforeGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.beforeIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.afterBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.afterGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.afterIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.giveBalanceTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.description = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public BigDecimal beforeBalance() {
        return Objects.nonNull(this.beforeBalance) ? this.beforeBalance : BigDecimal.ZERO;
    }

    public BigDecimal beforeGiveMoney() {
        return Objects.nonNull(this.beforeGiveMoney) ? this.beforeGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal beforeTotal() {
        return this.beforeBalance().add(this.beforeGiveMoney());
    }

    public BigDecimal beforeIntegral() {
        return Objects.nonNull(this.beforeIntegral) ? this.beforeIntegral : BigDecimal.ZERO;
    }

    public BigDecimal afterBalance() {
        return Objects.nonNull(this.afterBalance) ? this.afterBalance : BigDecimal.ZERO;
    }

    public BigDecimal afterGiveMoney() {
        return Objects.nonNull(this.afterGiveMoney) ? this.afterGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal afterTotal() {
        return this.afterBalance().add(this.afterGiveMoney());
    }

    public BigDecimal afterIntegral() {
        return Objects.nonNull(this.afterIntegral) ? this.afterIntegral : BigDecimal.ZERO;
    }

    public boolean isGiveForever() {
        return ByteUtils.isGiveForever(this.afterGiveMoney, this.giveBalanceTime);
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getIntegral() {
        return this.integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public BigDecimal getBeforeBalance() {
        return this.beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getBeforeGiveMoney() {
        return this.beforeGiveMoney;
    }

    public void setBeforeGiveMoney(BigDecimal beforeGiveMoney) {
        this.beforeGiveMoney = beforeGiveMoney;
    }

    public BigDecimal getBeforeIntegral() {
        return this.beforeIntegral;
    }

    public void setBeforeIntegral(BigDecimal beforeIntegral) {
        this.beforeIntegral = beforeIntegral;
    }

    public BigDecimal getAfterBalance() {
        return this.afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getAfterGiveMoney() {
        return this.afterGiveMoney;
    }

    public void setAfterGiveMoney(BigDecimal afterGiveMoney) {
        this.afterGiveMoney = afterGiveMoney;
    }

    public BigDecimal getAfterIntegral() {
        return this.afterIntegral;
    }

    public void setAfterIntegral(BigDecimal afterIntegral) {
        this.afterIntegral = afterIntegral;
    }

    public Date getGiveBalanceTime() {
        return this.giveBalanceTime;
    }

    public void setGiveBalanceTime(Date giveBalanceTime) {
        this.giveBalanceTime = giveBalanceTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

