/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Objects;

public class JKYPayRequest
extends AggregatedEntity {
    private String lockId;
    private int fid;
    private BigDecimal stored;
    private BigDecimal cash;
    private BigDecimal cloud;
    private String paycode;
    private int random = RandomUtils.integer_random(65535);
    private String title;
    private int count;
    private int retryCount;

    public JKYPayRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYPayRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.toSPFStrNone(this.stored)).append(ByteUtils.toSPFStrNone(this.cash)).append(ByteUtils.toSPFStrNone(this.cloud)).append(ByteUtils.a_text(this.paycode)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.a_text(this.title)).append(ByteUtils.int2Hex(this.count)).append(ByteUtils.int2Hex(this.retryCount));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.paycode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal stored() {
        return Objects.nonNull(this.stored) ? this.stored : BigDecimal.ZERO;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return this.cash().add(this.cloud());
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public BigDecimal getStored() {
        return this.stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return this.cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public String getPaycode() {
        return this.paycode;
    }

    public void setPaycode(String paycode) {
        this.paycode = paycode;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

