/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class JKYPayResponse
extends AggregatedEntity {
    private String lockId;
    private int code;
    private int fid;
    private String orderNo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expire;
    private String errCode;
    private String errMsg;
    private int tradeType;
    private BigDecimal stored;
    private BigDecimal cash;
    private BigDecimal cloud;
    private BigDecimal amount;
    private BigDecimal actual;
    private BigDecimal balance;
    private BigDecimal giveMoney;
    private BigDecimal integral;
    private BigDecimal surplusMoney;
    private BigDecimal surplusGiveMoney;
    private BigDecimal surplusIntegral;
    private int payWay;
    private int payType;
    private String cloudTradeNo;

    public JKYPayResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYPayResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2Hex(this.code)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.a_text(this.orderNo)).append(ByteUtils.timeToStrNone(this.expire)).append(ByteUtils.a_text(this.errCode)).append(ByteUtils.a_text(this.errMsg)).append(ByteUtils.int2Hex(this.tradeType)).append(ByteUtils.toSPFStrNone(this.stored)).append(ByteUtils.toSPFStrNone(this.cash)).append(ByteUtils.toSPFStrNone(this.cloud)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.toSPFStrNone(this.actual)).append(ByteUtils.toSPFStrNone(this.balance)).append(ByteUtils.toSPFStrNone(this.giveMoney)).append(ByteUtils.toSPFStrNone(this.integral)).append(ByteUtils.toSPFStrNone(this.surplusMoney)).append(ByteUtils.toSPFStrNone(this.surplusGiveMoney)).append(ByteUtils.toSPFStrNone(this.surplusIntegral)).append(ByteUtils.int2HexWithPush(this.payWay, 4)).append(ByteUtils.int2HexWithPush(this.payType, 4)).append(ByteUtils.a_text(this.cloudTradeNo));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.actual = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.balance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.giveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.surplusMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.surplusGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.surplusIntegral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.payWay = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.payType = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.cloudTradeNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public BigDecimal stored() {
        return Objects.nonNull(this.stored) ? this.stored : BigDecimal.ZERO;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return Objects.nonNull(this.amount) ? this.amount : this.cash().add(this.cloud());
    }

    public BigDecimal actual() {
        return Objects.nonNull(this.actual) ? this.actual : BigDecimal.ZERO;
    }

    public BigDecimal balance() {
        return Objects.nonNull(this.balance) ? this.balance : BigDecimal.ZERO;
    }

    public BigDecimal giveMoney() {
        return Objects.nonNull(this.giveMoney) ? this.giveMoney : BigDecimal.ZERO;
    }

    public BigDecimal integral() {
        return Objects.nonNull(this.integral) ? this.integral : BigDecimal.ZERO;
    }

    public BigDecimal surplusMoney() {
        return Objects.nonNull(this.surplusMoney) ? this.surplusMoney : BigDecimal.ZERO;
    }

    public BigDecimal surplusGiveMoney() {
        return Objects.nonNull(this.surplusGiveMoney) ? this.surplusGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal surplusIntegral() {
        return Objects.nonNull(this.surplusIntegral) ? this.surplusIntegral : BigDecimal.ZERO;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getStored() {
        return this.stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return this.cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getActual() {
        return this.actual;
    }

    public void setActual(BigDecimal actual) {
        this.actual = actual;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getGiveMoney() {
        return this.giveMoney;
    }

    public void setGiveMoney(BigDecimal giveMoney) {
        this.giveMoney = giveMoney;
    }

    public BigDecimal getIntegral() {
        return this.integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public BigDecimal getSurplusMoney() {
        return this.surplusMoney;
    }

    public void setSurplusMoney(BigDecimal surplusMoney) {
        this.surplusMoney = surplusMoney;
    }

    public BigDecimal getSurplusGiveMoney() {
        return this.surplusGiveMoney;
    }

    public void setSurplusGiveMoney(BigDecimal surplusGiveMoney) {
        this.surplusGiveMoney = surplusGiveMoney;
    }

    public BigDecimal getSurplusIntegral() {
        return this.surplusIntegral;
    }

    public void setSurplusIntegral(BigDecimal surplusIntegral) {
        this.surplusIntegral = surplusIntegral;
    }

    public int getPayWay() {
        return this.payWay;
    }

    public void setPayWay(int payWay) {
        this.payWay = payWay;
    }

    public int getPayType() {
        return this.payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public String getCloudTradeNo() {
        return this.cloudTradeNo;
    }

    public void setCloudTradeNo(String cloudTradeNo) {
        this.cloudTradeNo = cloudTradeNo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

