/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Objects;

public class JKYRechargeRequest
extends AggregatedEntity {
    private String lockId;
    private int fid;
    private int type;
    private int mealVersion;
    private int mealOrder;
    private BigDecimal cash;
    private BigDecimal cloud;
    private String paycode;
    private BigDecimal give;
    private int expireTime;
    private String remark;
    private int random = RandomUtils.integer_random(65535);
    private int retryCount;

    public JKYRechargeRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYRechargeRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.int2Hex(this.type)).append(ByteUtils.int2HexWithPush(this.mealVersion, 8)).append(ByteUtils.int2HexWithPush(this.mealOrder, 8)).append(ByteUtils.toSPFStrNone(this.cash)).append(ByteUtils.toSPFStrNone(this.cloud)).append(ByteUtils.a_text(this.paycode)).append(ByteUtils.toSPFStrNone(this.give)).append(ByteUtils.int2HexWithPush(this.expireTime, 4)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.int2Hex(this.retryCount));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.type = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.mealVersion = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.paycode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.give = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.expireTime = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return this.cash().add(this.cloud());
    }

    public BigDecimal give() {
        return Objects.nonNull(this.give) ? this.give : BigDecimal.ZERO;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMealVersion() {
        return this.mealVersion;
    }

    public void setMealVersion(int mealVersion) {
        this.mealVersion = mealVersion;
    }

    public int getMealOrder() {
        return this.mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return this.cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public String getPaycode() {
        return this.paycode;
    }

    public void setPaycode(String paycode) {
        this.paycode = paycode;
    }

    public BigDecimal getGive() {
        return this.give;
    }

    public void setGive(BigDecimal give) {
        this.give = give;
    }

    public int getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

