/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class JKYRechargeResponse
extends AggregatedEntity {
    private String lockId;
    private int code;
    private int fid;
    private String orderNo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expire;
    private String errCode;
    private String errMsg;
    private int tradeType;
    private BigDecimal cash;
    private BigDecimal cloud;
    private BigDecimal amount;
    private BigDecimal beforeBalance;
    private BigDecimal afterBalance;
    private BigDecimal beforeGiveMoney;
    private BigDecimal afterGiveMoney;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date giveMoneyTime;
    private int level;
    private String specialType;
    private BigDecimal discount;
    private int payWay;
    private int payType;
    private String cloudTradeNo;

    public JKYRechargeResponse() {
        super(new AggregatedMark(true, false));
    }

    public JKYRechargeResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.int2Hex(this.code)).append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.a_text(this.orderNo)).append(ByteUtils.timeToStrNone(this.expire)).append(ByteUtils.a_text(this.errCode)).append(ByteUtils.a_text(this.errMsg)).append(ByteUtils.int2Hex(this.tradeType)).append(ByteUtils.toSPFStrNone(this.cash)).append(ByteUtils.toSPFStrNone(this.cloud)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.toSPFStrNone(this.beforeBalance)).append(ByteUtils.toSPFStrNone(this.afterBalance)).append(ByteUtils.toSPFStrNone(this.beforeGiveMoney)).append(ByteUtils.toSPFStrNone(this.afterGiveMoney)).append(ByteUtils.timeToStrNone(this.giveMoneyTime)).append(ByteUtils.int2Hex(this.level)).append(ByteUtils.a_text(this.specialType)).append(ByteUtils.toSPFStrNone(this.discount)).append(ByteUtils.int2HexWithPush(this.payWay, 4)).append(ByteUtils.int2HexWithPush(this.payType, 4)).append(ByteUtils.a_text(this.cloudTradeNo));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        if ((index = ByteUtils.indexOf(innerContent, "00")) != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.tradeType = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cloud = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.beforeBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.afterBalance = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.beforeGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.afterGiveMoney = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.giveMoneyTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.level = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
        if (index != -1) {
            this.specialType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.discount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.payWay = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        this.payType = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.cloudTradeNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public BigDecimal cloud() {
        return Objects.nonNull(this.cloud) ? this.cloud : BigDecimal.ZERO;
    }

    public BigDecimal amount() {
        return Objects.nonNull(this.amount) ? this.amount : this.cash().add(this.cloud());
    }

    public BigDecimal beforeBalance() {
        return Objects.nonNull(this.beforeBalance) ? this.beforeBalance : BigDecimal.ZERO;
    }

    public BigDecimal afterBalance() {
        return Objects.nonNull(this.afterBalance) ? this.afterBalance : BigDecimal.ZERO;
    }

    public BigDecimal beforeGiveMoney() {
        return Objects.nonNull(this.beforeGiveMoney) ? this.beforeGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal afterGiveMoney() {
        return Objects.nonNull(this.afterGiveMoney) ? this.afterGiveMoney : BigDecimal.ZERO;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ZERO;
    }

    public BigDecimal getBeforeTotalBalance() {
        return this.beforeBalance().add(this.beforeGiveMoney());
    }

    public BigDecimal getAfterTotalBalance() {
        return this.afterBalance().add(this.afterGiveMoney());
    }

    public boolean isGiveForever() {
        return Objects.nonNull(this.afterGiveMoney) && BigDecimalUtils.compareMoreZeroValue(this.afterGiveMoney) && (Objects.isNull(this.giveMoneyTime) || DateUtils.TIME_2000_1_1_0_0_0.longValue() == this.giveMoneyTime.getTime());
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public int getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCloud() {
        return this.cloud;
    }

    public void setCloud(BigDecimal cloud) {
        this.cloud = cloud;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getBeforeBalance() {
        return this.beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getAfterBalance() {
        return this.afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getBeforeGiveMoney() {
        return this.beforeGiveMoney;
    }

    public void setBeforeGiveMoney(BigDecimal beforeGiveMoney) {
        this.beforeGiveMoney = beforeGiveMoney;
    }

    public BigDecimal getAfterGiveMoney() {
        return this.afterGiveMoney;
    }

    public void setAfterGiveMoney(BigDecimal afterGiveMoney) {
        this.afterGiveMoney = afterGiveMoney;
    }

    public Date getGiveMoneyTime() {
        return this.giveMoneyTime;
    }

    public void setGiveMoneyTime(Date giveMoneyTime) {
        this.giveMoneyTime = giveMoneyTime;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(String specialType) {
        this.specialType = specialType;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public int getPayWay() {
        return this.payWay;
    }

    public void setPayWay(int payWay) {
        this.payWay = payWay;
    }

    public int getPayType() {
        return this.payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public String getCloudTradeNo() {
        return this.cloudTradeNo;
    }

    public void setCloudTradeNo(String cloudTradeNo) {
        this.cloudTradeNo = cloudTradeNo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

