/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.jky.trade;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public class JKYRefundRequest
extends AggregatedEntity {
    private String lockId;
    private int fid;
    private int sid;
    private int scaleMan;
    private BigDecimal stored;
    private BigDecimal cash;
    private BigDecimal integral;
    private int balanceId;
    private int originalOrderFid;
    private String originalOrderNo;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date originalOrderTime;
    private int random = RandomUtils.integer_random(65535);
    private String title;
    private int count;
    private int retryCount;
    private String remark;
    private int autoLog;

    public JKYRefundRequest() {
        super(new AggregatedMark(true, true));
    }

    public JKYRefundRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.a_text(this.lockId)).append(ByteUtils.fid(this.fid)).append(ByteUtils.fid(this.sid)).append(ByteUtils.int2Hex(this.scaleMan)).append(ByteUtils.toSPFStrNone(this.stored)).append(ByteUtils.toSPFStrNone(this.cash)).append(ByteUtils.toSPFStrNone(this.integral)).append(ByteUtils.fid(this.balanceId)).append(ByteUtils.fid(this.originalOrderFid)).append(ByteUtils.a_text(this.originalOrderNo)).append(ByteUtils.timeToStrNone(this.originalOrderTime)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.a_text(this.title)).append(ByteUtils.int2Hex(this.count)).append(ByteUtils.int2Hex(this.retryCount)).append(ByteUtils.a_text(this.remark)).append(ByteUtils.int2Hex(this.autoLog));
    }

    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lockId = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.sid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.scaleMan = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.stored = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.cash = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.balanceId = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.originalOrderFid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(8), "00");
        if (index != -1) {
            this.originalOrderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.originalOrderTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        index = ByteUtils.indexOf(innerContent = innerContent.substring(2), "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.autoLog = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public BigDecimal stored() {
        return Objects.nonNull(this.stored) ? this.stored : BigDecimal.ZERO;
    }

    public BigDecimal cash() {
        return Objects.nonNull(this.cash) ? this.cash : BigDecimal.ZERO;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getScaleMan() {
        return this.scaleMan;
    }

    public void setScaleMan(int scaleMan) {
        this.scaleMan = scaleMan;
    }

    public BigDecimal getStored() {
        return this.stored;
    }

    public void setStored(BigDecimal stored) {
        this.stored = stored;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getIntegral() {
        return this.integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public int getBalanceId() {
        return this.balanceId;
    }

    public void setBalanceId(int balanceId) {
        this.balanceId = balanceId;
    }

    public int getOriginalOrderFid() {
        return this.originalOrderFid;
    }

    public void setOriginalOrderFid(int originalOrderFid) {
        this.originalOrderFid = originalOrderFid;
    }

    public String getOriginalOrderNo() {
        return this.originalOrderNo;
    }

    public void setOriginalOrderNo(String originalOrderNo) {
        this.originalOrderNo = originalOrderNo;
    }

    public Date getOriginalOrderTime() {
        return this.originalOrderTime;
    }

    public void setOriginalOrderTime(Date originalOrderTime) {
        this.originalOrderTime = originalOrderTime;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getAutoLog() {
        return this.autoLog;
    }

    public void setAutoLog(int autoLog) {
        this.autoLog = autoLog;
    }
}

