/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.rely;

import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DLOGUploadRequest
extends AggregatedEntity {
    private List<DLOGContent> contents;

    public DLOGUploadRequest() {
        super(new AggregatedMark(true, true));
    }

    public DLOGUploadRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        StringBuilder builder = new StringBuilder();
        if (this.contents != null && !this.contents.isEmpty()) {
            builder.append(ByteUtils.int2HexWithPush(this.contents.size(), 4));
            for (DLOGContent content : this.contents) {
                builder.append(ByteUtils.int2Hex(content.getEdition())).append(ByteUtils.int2HexWithPush(content.getFid(), 8)).append(ByteUtils.int2HexWithPush(content.getSid(), 8)).append(ByteUtils.int2HexWithPush(content.getLogType(), 4)).append(ByteUtils.timeToStrNone(new Date(content.getTradeDate())));
                int length = (StringUtils.isNotBlank((CharSequence)content.getLog()) ? content.getLog().length() : 0) / 2;
                if (length > 0) {
                    builder.append(ByteUtils.int2HexWithPush(length, 4)).append(content.getLog());
                    continue;
                }
                builder.append(ByteUtils.int2HexWithPush(0, 4));
            }
        } else {
            builder.append(ByteUtils.int2HexWithPush(0, 4));
        }
        return builder;
    }

    @Override
    public String inner_analyse(String innerContent) {
        int size = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                DLOGContent content = new DLOGContent();
                content.setEdition(ByteUtils.hex2Ten(innerContent.substring(0, 2)));
                innerContent = innerContent.substring(2);
                content.setFid(ByteUtils.hex2Ten(innerContent.substring(0, 8)));
                innerContent = innerContent.substring(8);
                content.setSid(ByteUtils.hex2Ten(innerContent.substring(0, 8)));
                innerContent = innerContent.substring(8);
                content.setLogType(ByteUtils.hex2Ten(innerContent.substring(0, 4)));
                innerContent = innerContent.substring(8);
                Date tradeDate = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
                tradeDate = Objects.nonNull(tradeDate) ? tradeDate : new Date();
                content.setTradeDate(tradeDate.getTime());
                innerContent = innerContent.substring(8);
                int length = ByteUtils.hex2Ten(innerContent.substring(0, 4)) * 2;
                content.setLog(innerContent.substring(4, 4 + length));
                innerContent = innerContent.substring(4 + length);
                this.add(content);
            }
        }
        return innerContent;
    }

    public DLOGUploadRequest add(DLOGContent ... contents) {
        if (contents != null && contents.length > 0) {
            if (this.contents == null) {
                this.contents = new ArrayList<DLOGContent>();
            }
            this.contents.addAll(Arrays.asList(contents));
        }
        return this;
    }

    public List<DLOGContent> getContents() {
        return this.contents;
    }

    public void setContents(List<DLOGContent> contents) {
        this.contents = contents;
    }
}

