/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.file;

import com.jhscale.common.em.Project;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FileName
implements GJSONModel {
    @ApiModelProperty(value="\u65f6\u95f4", name="date")
    private Date date;
    @ApiModelProperty(value="\u8eab\u4efd\u6807\u8bc6", name="account")
    private String account;
    @ApiModelProperty(value="\u529f\u80fd\u70b9", name="fuc")
    private String fuc;
    @ApiModelProperty(value="\u6587\u4ef6\u540d", name="name", required=true)
    private String name;
    @ApiModelProperty(value="\u6587\u4ef6\u7c7b\u578b", name="type")
    private String type;

    public String public_fileName() {
        return this.fileName(true, true);
    }

    public String public_dir() {
        return this.fileName(true, false);
    }

    public String server_fileName() {
        return this.fileName(false, true);
    }

    public String server_dir() {
        return this.fileName(false, false);
    }

    public FileName project(Project project) {
        this.fuc = Objects.nonNull((Object)project) ? project.getOssPath() : "";
        return this;
    }

    public FileName addName(String ... name_parts) {
        if (name_parts != null && name_parts.length > 0) {
            if (this.name == null) {
                this.name = "";
            }
            for (String part : name_parts) {
                this.name = this.name + "/" + part;
            }
        }
        return this;
    }

    public String fileName(boolean defaultDate, boolean defaultName) {
        String type;
        Date date;
        StringBuilder builder = new StringBuilder();
        Date date2 = Objects.nonNull(this.date) ? this.date : (date = defaultDate ? new Date() : null);
        if (Objects.nonNull(date)) {
            String date_yymmdd = DateUtils.getDate_YYMMDD(date);
            builder.append("/").append(date_yymmdd);
        }
        if (StringUtils.isNotBlank((CharSequence)this.account)) {
            builder.append("/").append(this.account);
        }
        if (StringUtils.isNotBlank((CharSequence)this.fuc)) {
            builder.append("/").append(this.fuc);
        }
        String string = type = StringUtils.isBlank((CharSequence)this.type) || this.type.startsWith(".") ? this.type : "." + this.type;
        while (StringUtils.isNotBlank((CharSequence)this.name) && this.name.startsWith("/")) {
            this.name = this.name.substring(1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            if (this.name.contains(".")) {
                builder.append("/").append(this.name);
            } else if (StringUtils.isNotBlank((CharSequence)type)) {
                builder.append("/").append(this.name).append(type);
            }
        } else if (StringUtils.isNotBlank((CharSequence)type)) {
            builder.append("/").append(System.currentTimeMillis()).append(type);
        } else if (defaultName) {
            builder.append("/").append(System.currentTimeMillis()).append(".jh");
        }
        String fileName = builder.toString();
        while (StringUtils.isNotBlank((CharSequence)fileName) && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    public Date getDate() {
        return this.date;
    }

    public FileName setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getAccount() {
        return this.account;
    }

    public FileName setAccount(String account) {
        this.account = account;
        return this;
    }

    public String getFuc() {
        return this.fuc;
    }

    public FileName setFuc(String fuc) {
        this.fuc = fuc;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public FileName setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public FileName setType(String type) {
        this.type = type;
        return this;
    }
}

