/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.http;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.SignatureException;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.common.utils.RandomUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface Signature
extends Serializable {
    default public void defaultInit() {
        this.setVersion(StringUtils.isNotBlank((CharSequence)this.getVersion()) ? this.getVersion() : "1.0");
        this.setNonce_str(StringUtils.isNotBlank((CharSequence)this.getNonce_str()) ? this.getNonce_str() : RandomUtils.getEncryptRandomStrByLength(32));
        this.setTimestamp(Objects.nonNull(this.getTimestamp()) ? this.getTimestamp() : Long.parseLong(String.valueOf(System.currentTimeMillis() / 1000L)));
        this.setSign_type(StringUtils.isNotBlank((CharSequence)this.getSign_type()) ? this.getSign_type() : "MD5");
    }

    default public String bulidSign(String key, String ... ignore) {
        return MD5Utils.bulidMD5Signature(this.toObjectMap(ignore), key);
    }

    default public String bulidSign_ad(String key, String ... ignore) {
        return MD5Utils.bulidMD5Signature_ad(this.toObjectMap(ignore), key);
    }

    default public String bulidSignSource(String key, String ... ignore) {
        return MD5Utils.bulidSourceSignature(this.toObjectMap(ignore), key);
    }

    default public String buliMD5Sign(String result) {
        return MD5Utils.bulidMD5Signature(result);
    }

    default public boolean check(String key) throws SignatureException {
        return this.checkPackage(key) && this.checkSign(key);
    }

    default public Map<String, String> toMap(String ... params) {
        boolean cont = false;
        List<Object> paramsList = new ArrayList();
        if (params != null && params.length > 0) {
            cont = true;
            paramsList = Arrays.asList(params);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getAllFieldList(this.getClass(), fields);
        for (Field field : fields) {
            if ("sign".equals(field.getName()) || cont && paramsList.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(this);
                if (obj == null) continue;
                if (obj instanceof String || obj instanceof BigDecimal) {
                    map.put(field.getName().replace("_$_", ""), obj.toString());
                    continue;
                }
                if (obj instanceof List) {
                    Object o;
                    List list = (List)obj;
                    if (list.isEmpty() || (o = list.get(0)) == null) continue;
                    if (o instanceof String || o instanceof BigDecimal) {
                        map.put(field.getName().replace("_$_", ""), o.toString());
                        continue;
                    }
                    map.put(field.getName().replace("_$_", ""), JSONObject.toJSONString((Object)obj));
                    continue;
                }
                map.put(field.getName().replace("_$_", ""), JSONObject.toJSONString((Object)obj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    default public Map toObjectMap(String ... params) {
        boolean cont = false;
        List<Object> paramsList = new ArrayList();
        if (params != null && params.length > 0) {
            cont = true;
            paramsList = Arrays.asList(params);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getAllFieldList(this.getClass(), fields);
        for (Field field : fields) {
            if ("sign".equals(field.getName()) || cont && paramsList.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(this);
                if (obj == null) continue;
                map.put(field.getName().replace("_$_", ""), obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    default public void getAllFieldList(Class clazz, List<Field> fields) {
        Class superclass;
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields != null && declaredFields.length > 0) {
            fields.addAll(Arrays.asList(declaredFields));
        }
        if (Objects.nonNull(superclass = clazz.getSuperclass())) {
            this.getAllFieldList(superclass, fields);
        }
    }

    default public boolean checkPackage(String key) throws SignatureException {
        return this.checkPackage(key, 300);
    }

    default public boolean checkPackage(String key, int validMin) throws SignatureException {
        if (StringUtils.isBlank((CharSequence)this.getVersion())) {
            throw new SignatureException(GeneralInternational.\u63a5\u53e3\u7248\u672c\u65e0\u6548);
        }
        if (StringUtils.isBlank((CharSequence)this.getNonce_str())) {
            throw new SignatureException(GeneralInternational.\u968f\u673a\u6570\u65e0\u6548);
        }
        if (Objects.isNull(this.getTimestamp())) {
            throw new SignatureException(GeneralInternational.\u65f6\u95f4\u6233\u4e0d\u5b58\u5728);
        }
        if (StringUtils.isBlank((CharSequence)this.getSign())) {
            throw new SignatureException(GeneralInternational.\u7b7e\u540d\u4e0d\u5b58\u5728);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new SignatureException(GeneralInternational.\u5bc6\u94a5\u4e0d\u5b58\u5728);
        }
        String timezone = StringUtils.isNotBlank((CharSequence)this.getTime_zone()) ? this.getTime_zone() : "8";
        Integer nowTime = Integer.parseInt(String.valueOf(DateUtils.getLongTime(new Date(), timezone) / 1000L));
        if ((long)nowTime.intValue() - this.getTimestamp() > (long)validMin) {
            throw new SignatureException(GeneralInternational.\u65f6\u95f4\u6233\u8d85\u65f6);
        }
        return true;
    }

    default public boolean checkSign(String key) throws SignatureException {
        if (!this.bulidSign(key, new String[0]).equals(this.getSign())) {
            throw new SignatureException(GeneralInternational.\u7b7e\u540d\u65e0\u6548);
        }
        return true;
    }

    public String getVersion();

    public void setVersion(String var1);

    public String getNonce_str();

    public void setNonce_str(String var1);

    public Long getTimestamp();

    public void setTimestamp(Long var1);

    public String getSign();

    public void setSign(String var1);

    public String getSign_type();

    public void setSign_type(String var1);

    public String getTime_zone();

    public void setTime_zone(String var1);

    default public String encrypt(String content) {
        if (StringUtils.isBlank((CharSequence)this.getNonce_str()) || Objects.isNull(this.getTimestamp())) {
            this.defaultInit();
        }
        return this.encrypt(content, this.getNonce_str(), this.getTimestamp());
    }

    default public String encrypt(String content, String nonce_str, Long timestamp) {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)nonce_str) || Objects.isNull(timestamp)) {
            return null;
        }
        nonce_str = nonce_str.toUpperCase();
        StringBuffer buffer = new StringBuffer(ByteUtils.int2Hex(content.length())).append(timestamp);
        for (int i = 0; i < nonce_str.length(); ++i) {
            try {
                buffer.append(content.charAt(i));
                int numChar = Integer.parseInt(String.valueOf(nonce_str.charAt(i)), 16) + i;
                buffer.append(nonce_str.charAt(numChar));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    default public String decrypt(String content) throws ProfessionalException {
        return this.decrypt(content, this.getNonce_str(), this.getTimestamp());
    }

    default public String decrypt(String content, String nonce_str, Long timestamp) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)nonce_str) || Objects.isNull(timestamp)) {
            return null;
        }
        try {
            int sign_index = content.indexOf(timestamp.toString());
            Integer length = Integer.parseInt(content.substring(0, sign_index), 16);
            content = content.substring(sign_index + timestamp.toString().length());
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            for (int i = 0; i < nonce_str.length() && buffer.length() != length.intValue(); ++i) {
                buffer.append(content.charAt(index));
                String part = null;
                try {
                    int numChar = Integer.parseInt(String.valueOf(nonce_str.charAt(i)), 16) + i;
                    part = String.valueOf(nonce_str.charAt(numChar));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                index = StringUtils.isNotBlank(part) ? index + 2 : index + 1;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProfessionalException(GeneralInternational.\u89e3\u5bc6\u5931\u8d25);
        }
    }
}

