/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.inter;

import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.common.utils.JSONUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface MapModel
extends Serializable {
    default public Map<String, Object> toMap() {
        Class<?> clazz = this.getClass();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        PropertyDescriptor[] propertyDescriptors = null;
        try {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.propertyDescriptors(clazz)) {
                Method gmethod = propertyDescriptor.getReadMethod();
                Method smethod = propertyDescriptor.getWriteMethod();
                if (null == gmethod || smethod == null) continue;
                try {
                    maps.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return maps;
        }
        catch (TechnologyException e) {
            return null;
        }
    }

    default public Map<String, String> toStringMap() {
        Map<String, Object> map = this.toMap();
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!Objects.nonNull(value)) continue;
                if (value instanceof JSONModel) {
                    stringMap.put(key, ((JSONModel)value).toJSON());
                    continue;
                }
                if (value instanceof com.jhscale.common.model.simple.JSONModel) {
                    stringMap.put(key, ((com.jhscale.common.model.simple.JSONModel)value).toJSON());
                    continue;
                }
                if (value instanceof String || value instanceof BigDecimal) {
                    stringMap.put(key, value.toString());
                    continue;
                }
                if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                    stringMap.put(key, String.valueOf(value));
                    continue;
                }
                stringMap.put(key, JSONUtils.objectToJSON(value));
            }
        }
        return stringMap;
    }

    default public void fillStringMap(Map<String, String> stringMap) {
        if (stringMap != null && !stringMap.isEmpty()) {
            Map<String, Field> stringFieldMap = this.allField(new String[0]);
            for (Map.Entry<String, Field> entry : stringFieldMap.entrySet()) {
                String key = entry.getKey();
                String value = stringMap.get(entry.getKey());
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                try {
                    Field field = entry.getValue();
                    field.setAccessible(true);
                    if (field.getType().equals(String.class)) {
                        field.set(this, value);
                        continue;
                    }
                    if (field.getType().equals(Integer.TYPE)) {
                        field.setInt(this, Integer.parseInt(value));
                        continue;
                    }
                    if (field.getType().equals(Integer.class)) {
                        field.set(this, Integer.parseInt(value));
                        continue;
                    }
                    if (field.getType().equals(Long.TYPE)) {
                        field.setLong(this, Long.parseLong(value));
                        continue;
                    }
                    if (field.getType().equals(Long.class)) {
                        field.set(this, Long.parseLong(value));
                        continue;
                    }
                    if (field.getType().equals(Float.TYPE)) {
                        field.setFloat(this, Float.parseFloat(value));
                        continue;
                    }
                    if (field.getType().equals(Float.class)) {
                        field.set(this, Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if (field.getType().equals(Double.TYPE)) {
                        field.setDouble(this, Double.parseDouble(value));
                        continue;
                    }
                    if (field.getType().equals(Double.class)) {
                        field.set(this, Double.parseDouble(value));
                        continue;
                    }
                    if (field.getType().equals(Boolean.TYPE)) {
                        field.setBoolean(this, Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.getType().equals(Boolean.class)) {
                        field.set(this, Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.getType().equals(BigDecimal.class)) {
                        field.set(this, new BigDecimal(value));
                        continue;
                    }
                    if (field.getType().equals(List.class)) {
                        Type genericType = field.getGenericType();
                        Class innerClazz = null;
                        if (genericType instanceof ParameterizedType) {
                            innerClazz = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        }
                        field.set(this, JSONUtils.jsonToList(value, innerClazz));
                        continue;
                    }
                    if (field.getType().equals(Map.class)) {
                        field.set(this, JSONUtils.jsonToObject(value, Map.class));
                        continue;
                    }
                    field.set(this, JSONUtils.jsonToObject(value, field.getType()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    default public PropertyDescriptor[] propertyDescriptors(Class<?> c) throws TechnologyException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException var4) {
            throw new TechnologyException((Throwable)var4, "Bean introspection failed: " + var4.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    default public Map<String, Field> allField(String ... ignoreArr) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        this.allField(this.getClass(), fieldMap, ignoreArr);
        return fieldMap;
    }

    default public Map<String, Field> field(String ... ignoreArr) {
        Field[] fields;
        List<String> ingrols = null;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        if (ignoreArr != null) {
            ingrols = Arrays.asList(ignoreArr);
        }
        if ((fields = this.getClass().getDeclaredFields()) != null && fields.length > 0) {
            for (Field field : fields) {
                if (ingrols != null && ingrols.contains(field.getName())) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }

    default public List<Field> allFieldList(String ... ignoreArr) {
        Map<String, Field> map = this.allField(ignoreArr);
        return Optional.ofNullable(map).orElse(Collections.emptyMap()).values().stream().map(field -> field).collect(Collectors.toList());
    }

    default public Map<String, Field> allAndroidField() {
        return this.allField("shadow$_klass_", "shadow$_monitor_");
    }

    default public List<String> sortMapKey(Map<String, Field> fieldMap) {
        if (fieldMap != null && !fieldMap.isEmpty()) {
            Set<String> keys = fieldMap.keySet();
            String[] keyArray = keys.toArray(new String[fieldMap.size()]);
            Arrays.sort(keyArray, String.CASE_INSENSITIVE_ORDER);
            return Arrays.asList(keyArray);
        }
        return null;
    }

    default public void allField(Class clazz, Map<String, Field> fieldMap, String ... ignoreArr) {
        Class superclass;
        Field[] fields;
        List<String> ingrols = null;
        if (ignoreArr != null) {
            ingrols = Arrays.asList(ignoreArr);
        }
        if ((fields = clazz.getDeclaredFields()) != null && fields.length > 0) {
            for (Field field : fields) {
                if (ingrols != null && ingrols.contains(field.getName())) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            this.allField(superclass, fieldMap, ignoreArr);
        }
    }
}

