/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.license;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.license.LicenseHolder;
import com.jhscale.common.model.license.LicenseIssuer;
import com.jhscale.common.model.license.LicenseParam;
import com.jhscale.common.model.license.LicenseVersion;
import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.common.model.license.RSAKey;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.common.utils.RandomUtils;
import io.swagger.annotations.ApiModel;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="\u8bc1\u4e66\u5185\u5bb9")
public class LicenseContent
extends JSONModel {
    private LicenseHolder licenseHolder;
    private Integer prodSerial;
    private String subject;
    private String alias;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date issuedTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expiryTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date prodTime;
    private String prodTimeVal;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date mfgTime;
    private String mfgTimeVal;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date validTime;
    private String validTimeVal;
    private String consumerType = "user";
    private Integer consumerAmount = 1;
    private String description = "";
    private String nonce;
    private String sign;
    private LicenseParam licenseParam;
    private LicenseIssuer licenseIssuer;

    public void sign() {
        LicenseVersion serial = LicenseVersion.serial(this.prodSerial);
        if (Objects.nonNull((Object)serial)) {
            switch (serial) {
                case VERSION1: {
                    this.nonce = StringUtils.isNotBlank((CharSequence)this.nonce) ? this.nonce : RandomUtils.getRandomHexUpper(32);
                    StringBuilder privateKey = new StringBuilder();
                    for (int i = 0; i < this.nonce.length(); ++i) {
                        privateKey.append(i % 2 == 0 ? Character.valueOf(this.nonce.charAt(i)) : "");
                    }
                    this.sign = MD5Utils.bulidMD5Signature(MD5Utils.bulidSourceSignature_date(this.toObjMap(new String[0]), privateKey.toString()));
                }
            }
        }
    }

    public String encryptByPrivateKey(RSAEncryptDecrypt rsa, String privateKey) throws TechnologyException {
        return rsa.encryptByPrivateKey(this.toJSON(), privateKey);
    }

    public String encryptByPrivateKey(RSAEncryptDecrypt rsa, RSAKey rsaKey) throws TechnologyException {
        return rsa.encrypt(this.encryptByPrivateKey(rsa, rsaKey.getPrivateKey()) + "&&" + rsaKey.getPublicKey());
    }

    public String encryptByPublicKey(RSAEncryptDecrypt rsa, String publicKey) throws TechnologyException {
        return rsa.encryptByPublicKey(this.toJSON(), publicKey);
    }

    public String encryptByPublicKey(RSAEncryptDecrypt rsa, RSAKey rsaKey) throws TechnologyException {
        return rsa.encrypt(this.encryptByPublicKey(rsa, rsaKey.getPublicKey()) + "&&" + rsaKey.getPrivateKey());
    }

    public static LicenseContent decryptByPublicKey(RSAEncryptDecrypt rsa, String encrypt, String publicKey) throws TechnologyException {
        return JSONUtils.jsonToObject(rsa.decryptByPublicKey(encrypt, publicKey), LicenseContent.class);
    }

    public static LicenseContent decryptByPublicKey(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        return JSONUtils.jsonToObject(LicenseContent.decryptByPublicKeyRString(rsa, encrypt), LicenseContent.class);
    }

    public static String decryptByPublicKeyRString(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        String[] encryptArr = rsa.decrypt(encrypt).split("&&");
        return rsa.decryptByPublicKey(encryptArr[0], encryptArr[1]);
    }

    public static LicenseContent decryptByPrivateKey(RSAEncryptDecrypt rsa, String encrypt, String privateKey) throws TechnologyException {
        return JSONUtils.jsonToObject(rsa.decryptByPrivateKey(encrypt, privateKey), LicenseContent.class);
    }

    public static LicenseContent decryptByPrivateKey(RSAEncryptDecrypt rsa, String encrypt) throws TechnologyException {
        String[] encryptArr = rsa.decrypt(encrypt).split("&&");
        return JSONUtils.jsonToObject(rsa.decryptByPrivateKey(encryptArr[0], encryptArr[1]), LicenseContent.class);
    }

    public LicenseHolder getLicenseHolder() {
        return this.licenseHolder;
    }

    public void setLicenseHolder(LicenseHolder licenseHolder) {
        this.licenseHolder = licenseHolder;
    }

    public Integer getProdSerial() {
        return this.prodSerial;
    }

    public void setProdSerial(Integer prodSerial) {
        this.prodSerial = prodSerial;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Date getIssuedTime() {
        return this.issuedTime;
    }

    public void setIssuedTime(Date issuedTime) {
        this.issuedTime = issuedTime;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Date getProdTime() {
        return this.prodTime;
    }

    public void setProdTime(Date prodTime) {
        this.prodTime = prodTime;
        this.prodTimeVal = ByteUtils.timeToStrNone(prodTime);
    }

    public Date getMfgTime() {
        return this.mfgTime;
    }

    public void setMfgTime(Date mfgTime) {
        this.mfgTime = mfgTime;
        this.mfgTimeVal = ByteUtils.timeToStrNone(mfgTime);
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
        this.validTimeVal = ByteUtils.timeToStrNone(validTime);
    }

    public String getProdTimeVal() {
        return this.prodTimeVal;
    }

    public void setProdTimeVal(String prodTimeVal) {
        this.prodTimeVal = prodTimeVal;
    }

    public String getMfgTimeVal() {
        return this.mfgTimeVal;
    }

    public void setMfgTimeVal(String mfgTimeVal) {
        this.mfgTimeVal = mfgTimeVal;
    }

    public String getValidTimeVal() {
        return this.validTimeVal;
    }

    public void setValidTimeVal(String validTimeVal) {
        this.validTimeVal = validTimeVal;
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public Integer getConsumerAmount() {
        return this.consumerAmount;
    }

    public void setConsumerAmount(Integer consumerAmount) {
        this.consumerAmount = consumerAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public LicenseParam getLicenseParam() {
        return this.licenseParam;
    }

    public void setLicenseParam(LicenseParam licenseParam) {
        this.licenseParam = licenseParam;
    }

    public LicenseIssuer getLicenseIssuer() {
        return this.licenseIssuer;
    }

    public void setLicenseIssuer(LicenseIssuer licenseIssuer) {
        this.licenseIssuer = licenseIssuer;
    }

    public String toString() {
        return "LicenseContent{licenseHolder=" + this.licenseHolder + ", subject='" + this.subject + '\'' + ", alias='" + this.alias + '\'' + ", issuedTime=" + this.issuedTime + ", expiryTime=" + this.expiryTime + ", consumerType='" + this.consumerType + '\'' + ", consumerAmount=" + this.consumerAmount + ", description='" + this.description + '\'' + ", licenseParam=" + this.licenseParam + ", licenseIssuer=" + this.licenseIssuer + '}';
    }
}

