/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.system;

import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.system.LinuxTerminal;
import com.jhscale.common.system.OtherTerminal;
import com.jhscale.common.system.WindowsTerminal;
import com.jhscale.common.system.entity.TerminalInfo;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTerminal
implements Serializable {
    public static TerminalInfo terminalInfo(String osName, OtherTerminal otherTerminal) {
        if (StringUtils.isBlank((CharSequence)osName)) {
            osName = System.getProperty("os.name");
        }
        osName = osName.toLowerCase();
        AbstractTerminal terminal = null;
        terminal = osName.startsWith("windows") ? new WindowsTerminal() : (osName.startsWith("linux") ? new LinuxTerminal() : otherTerminal.otherTerminal(osName));
        return terminal.terminalInfo();
    }

    public TerminalInfo terminalInfo() {
        TerminalInfo terminalInfo = new TerminalInfo();
        try {
            terminalInfo.setIpAddresses(this.getIpAddresses());
            terminalInfo.setMacAddresses(this.getMacAddresses());
            terminalInfo.setCpuSerial(this.getCPUSerial());
            terminalInfo.setMainBoardSerial(this.getMainBoardSerial());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return terminalInfo;
    }

    public abstract List<String> getIpAddresses() throws ProfessionalException;

    protected abstract List<String> getMacAddresses() throws ProfessionalException;

    protected abstract String getCPUSerial() throws ProfessionalException;

    protected abstract String getMainBoardSerial() throws ProfessionalException;

    protected List<InetAddress> getLocalAllInetAddresses() throws ProfessionalException {
        try {
            ArrayList<InetAddress> result = new ArrayList<InetAddress>(4);
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddr = inetAddresses.nextElement();
                    if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isMulticastAddress()) continue;
                    result.add(inetAddr);
                }
            }
            return result;
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw new ProfessionalException(GeneralInternational.\u7f51\u7edc\u63a5\u53e3\u83b7\u53d6\u5931\u8d25);
        }
    }

    protected String getMacByInetAddress(InetAddress inetAddress) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            if (mac != null) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < mac.length; ++i) {
                    String temp;
                    if (i != 0) {
                        buffer.append("-");
                    }
                    buffer.append((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + temp : temp);
                }
                return buffer.toString().toUpperCase();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }
}

