/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.system;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.system.AbstractTerminal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LinuxTerminal
extends AbstractTerminal {
    @Override
    public List<String> getIpAddresses() throws ProfessionalException {
        ArrayList<String> result = new ArrayList<String>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                result.add(inetAddress.getHostAddress());
            }
        }
        return result;
    }

    @Override
    protected List<String> getMacAddresses() throws ProfessionalException {
        ArrayList<String> result = new ArrayList<String>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && inetAddresses.size() > 0) {
            for (InetAddress inetAddress : inetAddresses) {
                String mac = super.getMacByInetAddress(inetAddress);
                if (!StringUtils.isNotBlank((CharSequence)mac)) continue;
                result.add(mac);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getCPUSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        BufferedReader reader = null;
        String serialNumber = null;
        try {
            String[] shell = new String[]{"/bin/bash", "-c", "dmidecode -t processor | grep 'ID' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            outputStream = process.getOutputStream();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (StringUtils.isNotBlank((CharSequence)line)) {
                serialNumber = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getMainBoardSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        BufferedReader reader = null;
        String serialNumber = null;
        try {
            String[] shell = new String[]{"/bin/bash", "-c", "dmidecode | grep 'Serial Number' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            outputStream = process.getOutputStream();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (StringUtils.isNotBlank((CharSequence)line)) {
                serialNumber = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }
}

