/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.system;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.system.AbstractTerminal;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;

public class WindowsTerminal
extends AbstractTerminal {
    @Override
    public List<String> getIpAddresses() throws ProfessionalException {
        ArrayList<String> result = new ArrayList<String>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                result.add(inetAddress.getHostAddress());
            }
        }
        return result;
    }

    @Override
    protected List<String> getMacAddresses() throws ProfessionalException {
        ArrayList<String> result = new ArrayList<String>();
        List<InetAddress> inetAddresses = super.getLocalAllInetAddresses();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            for (InetAddress inetAddress : inetAddresses) {
                String mac = super.getMacByInetAddress(inetAddress);
                if (!StringUtils.isNotBlank((CharSequence)mac)) continue;
                result.add(mac);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getCPUSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        Scanner scanner = null;
        String serialNumber = null;
        try {
            Process process = Runtime.getRuntime().exec("wmic cpu get processorid");
            outputStream = process.getOutputStream();
            scanner = new Scanner(process.getInputStream());
            if (scanner != null && scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getMainBoardSerial() throws ProfessionalException {
        OutputStream outputStream = null;
        Scanner scanner = null;
        String serialNumber = "";
        try {
            Process process = Runtime.getRuntime().exec("wmic baseboard get serialnumber");
            outputStream = process.getOutputStream();
            scanner = new Scanner(process.getInputStream());
            if (scanner != null && scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return serialNumber;
    }
}

