/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AES128 {
    private static final Logger logger = LoggerFactory.getLogger(AES128.class);
    final String KEY_ALGORITHM = "AES";
    final String algorithmStr = "AES/CBC/PKCS7Padding";
    private Key key;
    private Cipher cipher;

    private AES128() {
    }

    public static AES128 getInstance() {
        return Single.INSTANCE;
    }

    public static String buildAESKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            return ByteUtils.parseByte2HexStr(b);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("AES Bulid Invalid", (Throwable)e);
            return null;
        }
    }

    public static String buildIV() {
        return RandomUtils.getGUID();
    }

    private void init(byte[] keyBytes) {
        int base = 16;
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.key = new SecretKeySpec(keyBytes, "AES");
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            logger.error("AES Init Error", (Throwable)e);
        }
    }

    public byte[] encrypt(byte[] content, byte[] aesKey, byte[] iv) {
        byte[] encrypt = null;
        try {
            this.init(aesKey);
            this.cipher.init(1, this.key, new IvParameterSpec(iv));
            encrypt = this.cipher.doFinal(content);
        }
        catch (Exception e) {
            logger.error("AES encrypt Error", (Throwable)e);
        }
        return encrypt;
    }

    public String encrypt(String content, String aesKey, String iv) {
        return Base64.encode(this.encrypt(content.getBytes(), aesKey.getBytes(), iv.getBytes()));
    }

    public byte[] decrypt(byte[] encryptedData, byte[] aesKey, byte[] iv) {
        byte[] decrypt = null;
        this.init(aesKey);
        try {
            this.cipher.init(2, this.key, new IvParameterSpec(iv));
            decrypt = this.cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            logger.error("AES decrypt Error", (Throwable)e);
        }
        return decrypt;
    }

    public String decrypt(String encryptedData, String aesKey, String iv) {
        try {
            return new String(this.decrypt(Base64.decode(encryptedData), aesKey.getBytes(), iv.getBytes()));
        }
        catch (Base64DecodingException e) {
            logger.error("AES Base decrypt Error", (Throwable)e);
            return null;
        }
    }

    public static class Single {
        private static AES128 INSTANCE = new AES128();
    }
}

