/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.utils.ByteUtils;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesHexUtils {
    private static final String AES = "AES";
    public static final String AES_ECB_PADDING = "AES/ECB/NoPadding";
    public static final String AES_CBC_PKCS5Padding = "AES/CBC/PKCS5Padding";

    private AesHexUtils() {
    }

    public static byte[] encrypt(byte[] content, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(1, spec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return AesHexUtils.encrypt(content, AES_ECB_PADDING, key);
        }
    }

    public static String encrypt(String content, String key) {
        return ByteUtils.toHexString(AesHexUtils.encrypt(ByteUtils.fromHexString(content), key));
    }

    public static byte[] encrypt(byte[] content, String padding, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(padding);
            cipher.init(1, spec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static byte[] decrypt(byte[] content, String key) {
        return AesHexUtils.decrypt(content, AES_ECB_PADDING, key);
    }

    public static String decrypt(String content, String key) {
        return ByteUtils.toHexString(AesHexUtils.decrypt(ByteUtils.fromHexString(content), key));
    }

    public static byte[] decrypt(byte[] content, String padding, String key) {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(padding);
            cipher.init(2, spec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

