/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.model.device.Angle;
import java.text.DecimalFormat;

public class AngleUtils {
    public static Angle oblique(int[] coordinate, int fullScale, int noise, int[] levels) {
        DecimalFormat df = new DecimalFormat("#.00");
        double x = (double)coordinate[0] / (double)noise;
        double y = (double)coordinate[1] / (double)noise;
        double f = (double)fullScale / (double)noise;
        double roll = Math.toDegrees(Math.atan(x / f));
        double pitch = Math.toDegrees(Math.atan(y / f));
        double total = Math.toDegrees(Math.atan(Math.sqrt(x * x + y * y) / f));
        double[] angle = new double[]{Double.parseDouble(df.format(roll)), Double.parseDouble(df.format(pitch)), Double.parseDouble(df.format(total))};
        int[] adjust = new int[2];
        int _x = (int)x;
        int _y = (int)y;
        if (_x > 0) {
            adjust = new int[]{1, -1};
        } else if (_x < 0) {
            adjust = new int[]{-1, 1};
        } else if (_y > 0) {
            adjust = new int[]{1, 1};
        } else if (_y < 0) {
            adjust = new int[]{-1, -1};
        }
        double distance = Math.sqrt(coordinate[0] * coordinate[0] + coordinate[1] * coordinate[1]);
        int level = -1;
        for (int i = 0; i < levels.length; ++i) {
            if (!(distance <= (double)levels[i])) continue;
            level = i;
            break;
        }
        return new Angle(new int[]{_x, _y}, angle, adjust, Double.parseDouble(df.format(distance)), level);
    }
}

