/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Base64 {
    private static char[] alphabet;
    private static byte[] codes;

    public static String encode(String data) {
        return new String(Base64.encode(data.getBytes()));
    }

    public static String decode(String data) {
        return new String(Base64.decode(data.toCharArray()));
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        for (int ix = 0; ix < data.length; ++ix) {
            if (data[ix] <= '\u00ff' && codes[data[ix]] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            int value;
            int n = value = data[ix] > '\u00ff' ? -1 : codes[data[ix]];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    public static void encode(File file) throws IOException {
        if (!file.exists()) {
            System.exit(0);
        } else {
            byte[] decoded = Base64.readBytes(file);
            char[] encoded = Base64.encode(decoded);
            Base64.writeChars(file, encoded);
        }
        file = null;
    }

    public static void decode(File file) throws IOException {
        if (!file.exists()) {
            System.exit(0);
        } else {
            char[] encoded = Base64.readChars(file);
            byte[] decoded = Base64.decode(encoded);
            Base64.writeBytes(file, decoded);
        }
        file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = null;
        FileInputStream fis = null;
        InputStream is = null;
        try {
            fis = new FileInputStream(file);
            is = new BufferedInputStream(fis);
            int count = 0;
            byte[] buf = new byte[16384];
            while ((count = is.read(buf)) != -1) {
                if (count <= 0) continue;
                baos.write(buf, 0, count);
            }
            b = baos.toByteArray();
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
                if (is != null) {
                    is.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] readChars(File file) throws IOException {
        CharArrayWriter caw = new CharArrayWriter();
        FileReader fr = null;
        Reader in = null;
        try {
            fr = new FileReader(file);
            in = new BufferedReader(fr);
            int count = 0;
            char[] buf = new char[16384];
            while ((count = in.read(buf)) != -1) {
                if (count <= 0) continue;
                caw.write(buf, 0, count);
            }
        }
        finally {
            try {
                if (caw != null) {
                    caw.close();
                }
                if (in != null) {
                    in.close();
                }
                if (fr != null) {
                    ((Reader)fr).close();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return caw.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBytes(File file, byte[] data) throws IOException {
        FileOutputStream fos = null;
        OutputStream os = null;
        try {
            fos = new FileOutputStream(file);
            os = new BufferedOutputStream(fos);
            os.write(data);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChars(File file, char[] data) throws IOException {
        FileWriter fos = null;
        Writer os = null;
        try {
            fos = new FileWriter(file);
            os = new BufferedWriter(fos);
            os.write(data);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fos != null) {
                    ((Writer)fos).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        int i;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.codes[i] = (byte)(52 + i - 48);
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

