/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64Utils {
    private static final String DEFAULT_ENCODING = "gbk";
    private static final String UTF_8 = "UTF-8";

    private Base64Utils() {
    }

    public static String encode(byte[] bs) {
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])bs);
    }

    public static byte[] decode(String str) {
        return org.apache.commons.codec.binary.Base64.decodeBase64((String)str);
    }

    public static String decodeData(String inputData) {
        try {
            if (null == inputData) {
                return null;
            }
            return new String(org.apache.commons.codec.binary.Base64.decodeBase64((byte[])inputData.getBytes(UTF_8)), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(inputData + "exp: " + e.getMessage());
            return null;
        }
    }

    public static String encodeData(String inputData) {
        try {
            if (null == inputData) {
                return null;
            }
            return new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])inputData.getBytes(UTF_8)), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(inputData + "exp: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gzipString(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        ByteArrayOutputStream out = null;
        DeflaterOutputStream gout = null;
        try {
            out = new ByteArrayOutputStream();
            gout = new GZIPOutputStream(out);
            gout.write(primStr.getBytes(DEFAULT_ENCODING));
            gout.flush();
        }
        catch (IOException e) {
            System.err.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u52a0\u538b\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 exp: " + e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (gout != null) {
                try {
                    gout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(Base64.encode(out.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String ungzipString(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gin = null;
        String decompressed = null;
        try {
            byte[] compressed = Base64.decode(compressedStr.toCharArray());
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(compressed);
            gin = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = gin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString(DEFAULT_ENCODING);
        }
        catch (IOException e) {
            System.err.println("\u5bf9\u5b57\u7b26\u4e32\u8fdb\u884c\u89e3\u5bc6\u89e3\u538b\u64cd\u4f5c\u5931\u8d25 exp: " + e.getMessage());
            decompressed = null;
        }
        finally {
            if (gin != null) {
                try {
                    gin.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return decompressed;
    }
}

