/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.em.NumberType;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.ysscale.UnitEnum;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BigDecimalUtils {
    private static BigDecimal base = new BigDecimal(100);
    private static Map<String, BigDecimal> unitConvert = new HashMap<String, BigDecimal>();

    private BigDecimalUtils() {
    }

    public static BigDecimal getYuanMoney(BigDecimal bigDecimal) {
        return bigDecimal.divide(base);
    }

    public static BigDecimal centToYuan(int cent) {
        return new BigDecimal(cent).divide(base);
    }

    public static String centToYuanStr(int cent) {
        return new BigDecimal(cent).divide(base).toString();
    }

    public static BigDecimal getMinMoney(BigDecimal normalMoney, Integer point) {
        if (normalMoney == null) {
            return new BigDecimal(0);
        }
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; ++i) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return normalMoney.divide(pointVal);
    }

    public static BigDecimal getMinBigMoney(Integer normalMoney, Integer point) {
        if (normalMoney == null) {
            return new BigDecimal(0);
        }
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; ++i) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return new BigDecimal(normalMoney).divide(pointVal);
    }

    public static double getMinMoney(Integer normalMoney, Integer point) {
        if (normalMoney == null) {
            return new BigDecimal(0).doubleValue();
        }
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; ++i) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return new BigDecimal(normalMoney).divide(pointVal).doubleValue();
    }

    public static BigDecimal getNormalMoney(BigDecimal minMoney, Integer point) {
        if (minMoney == null) {
            return new BigDecimal(0);
        }
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; ++i) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        BigDecimal multiply = minMoney.multiply(pointVal);
        return multiply.setScale(0, 1);
    }

    public static Integer getNormalMoney(Double minMoney, Integer point) {
        if (minMoney == null) {
            return 0;
        }
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; ++i) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        BigDecimal multiply = new BigDecimal(minMoney).multiply(pointVal);
        return multiply.setScale(0, 1).intValue();
    }

    public static BigDecimal getDivideMoney(BigDecimal bigDecimal) {
        BigDecimal multiply = bigDecimal.multiply(base);
        return multiply.setScale(0, 1);
    }

    public static int yuanToCent(BigDecimal yuan) {
        return yuan.multiply(base).intValue();
    }

    public static int strYuanToCent(String yuan) {
        return new BigDecimal(yuan).multiply(base).intValue();
    }

    public static int compareValue(BigDecimal val1, BigDecimal val2) {
        return val1.compareTo(val2);
    }

    public static boolean compareEqual(BigDecimal val1, BigDecimal val2) {
        return BigDecimalUtils.compareValue(val1, val2) == 0;
    }

    public static boolean compareMoreZeroValue(BigDecimal val1) {
        return BigDecimalUtils.compareValue(val1, BigDecimal.ZERO) == 1;
    }

    public static boolean compareLessZeroValue(BigDecimal val1) {
        return BigDecimalUtils.compareValue(val1, BigDecimal.ZERO) == -1;
    }

    public static boolean compareZeroValue(BigDecimal val1) {
        return BigDecimalUtils.compareValue(val1, BigDecimal.ZERO) == 0;
    }

    public static BigDecimal changeSgin(BigDecimal bigDecimal) {
        return bigDecimal.negate();
    }

    public static BigDecimal reverse(BigDecimal val) {
        return val.negate();
    }

    public static BigDecimal getValue(BigDecimal val1, BigDecimal val2) {
        val2 = val2.divide(new BigDecimal(100));
        return val1.multiply(val2);
    }

    public static NumberType compareNumber(BigDecimal number) {
        if (Objects.isNull(number)) {
            return NumberType.UNKNOW;
        }
        if (new BigDecimal(number.byteValue()).compareTo(number) == 0 && number.byteValue() >= -128 && number.byteValue() <= 127) {
            return NumberType.BYTE;
        }
        if (new BigDecimal(number.shortValue()).compareTo(number) == 0 && number.shortValue() >= Short.MIN_VALUE && number.shortValue() <= Short.MAX_VALUE) {
            return NumberType.SHORT;
        }
        if (new BigDecimal(number.intValue()).compareTo(number) == 0 && number.intValue() >= Integer.MIN_VALUE && number.intValue() <= Integer.MAX_VALUE) {
            return NumberType.INTEGER;
        }
        if (new BigDecimal(number.longValue()).compareTo(number) == 0) {
            return NumberType.LONG;
        }
        if (BigDecimal.valueOf(number.floatValue()).compareTo(number) == 0) {
            return NumberType.FLOAT;
        }
        return NumberType.DOUBLIE;
    }

    public static BigDecimal secondWeight(BigDecimal secondWeight, UnitEnum master, UnitEnum second, int scale, int round) {
        return (master.equals((Object)second) ? secondWeight : secondWeight.multiply(unitConvert.get(second.getName())).divide(unitConvert.get(master.getName())).setScale(scale, round)).setScale(scale, round);
    }

    public static BigDecimal secondWeight(BigDecimal secondWeight, UnitEnum master, UnitEnum second) {
        return BigDecimalUtils.secondWeight(secondWeight, master, second, 2, 4);
    }

    public static BigDecimal masterWeight(BigDecimal masterWeight, UnitEnum master, UnitEnum second, int scale, int round) {
        return (master.equals((Object)second) ? masterWeight : masterWeight.multiply(unitConvert.get(master.getName())).divide(unitConvert.get(second.getName())).setScale(scale, round)).setScale(scale, round);
    }

    public static BigDecimal masterWeight(BigDecimal masterWeight, UnitEnum master, UnitEnum second) {
        return BigDecimalUtils.masterWeight(masterWeight, master, second, 2, 4);
    }

    public static BigDecimal[] weight(BigDecimal masterWeigh, BigDecimal secondWeight, UnitEnum master, UnitEnum second) {
        BigDecimal secondAdd;
        BigDecimal masterAdd;
        BigDecimal _secondWeight = BigDecimalUtils.reverse(BigDecimalUtils.secondWeight(secondWeight, master, second));
        if (BigDecimalUtils.compareValue(masterWeigh, _secondWeight) == 1) {
            masterAdd = BigDecimalUtils.reverse(_secondWeight);
            secondAdd = BigDecimalUtils.reverse(BigDecimalUtils.secondWeight(secondWeight, second, second));
        } else if (BigDecimalUtils.compareValue(masterWeigh, _secondWeight) == 0) {
            masterAdd = BigDecimalUtils.reverse(BigDecimalUtils.masterWeight(masterWeigh, master, master));
            secondAdd = BigDecimalUtils.reverse(BigDecimalUtils.secondWeight(secondWeight, second, second));
        } else {
            masterAdd = BigDecimalUtils.reverse(BigDecimalUtils.masterWeight(masterWeigh, master, master));
            secondAdd = BigDecimalUtils.masterWeight(masterWeigh, master, second);
        }
        return new BigDecimal[]{masterAdd, secondAdd};
    }

    public static BigDecimal[] amount(BigDecimal masterAmount, BigDecimal secondAmount, BigDecimal ratio) {
        BigDecimal secondAdd;
        BigDecimal masterAdd;
        BigDecimal _secondAmount;
        BigDecimal _masterAmount = masterAmount.multiply(ratio);
        if (BigDecimalUtils.compareValue(_masterAmount, _secondAmount = BigDecimalUtils.reverse(secondAmount)) == 1) {
            BigDecimal[] result = _secondAmount.divideAndRemainder(ratio);
            masterAdd = BigDecimalUtils.reverse(result[0].add(BigDecimal.ONE));
            secondAdd = result[0].add(BigDecimal.ONE).multiply(ratio);
        } else if (BigDecimalUtils.compareValue(_masterAmount, _secondAmount) == 0) {
            masterAdd = BigDecimalUtils.reverse(masterAmount);
            secondAdd = _masterAmount;
        } else {
            masterAdd = BigDecimalUtils.reverse(masterAmount);
            secondAdd = _masterAmount;
        }
        return new BigDecimal[]{masterAdd, secondAdd};
    }

    public static BigDecimal unitToUnitRatio(UnitEnum master, UnitEnum second) {
        if (Objects.isNull((Object)master) || Objects.isNull((Object)second)) {
            return BigDecimal.ONE;
        }
        if (master.equals((Object)second)) {
            return BigDecimal.ONE;
        }
        if (master.getType().equals((Object)second.getType())) {
            if (UnitType.\u8ba1\u4ef6.equals((Object)master.getType())) {
                return BigDecimal.ONE;
            }
            BigDecimal masterBigDecimal = unitConvert.get(master.getName());
            BigDecimal secondBigDecimal = unitConvert.get(second.getName());
            return masterBigDecimal.divide(secondBigDecimal, 4, 4);
        }
        return BigDecimal.ONE;
    }

    public static int getNumberOfDecimalPlace(BigDecimal bigDecimal) {
        String s = bigDecimal.toPlainString();
        int index = s.indexOf(46);
        return index < 0 ? 0 : s.length() - 1 - index;
    }

    public static int getNumberOfDecimalPlace2(BigDecimal bigDecimal) {
        String s = bigDecimal.toPlainString();
        int index = s.indexOf(46);
        if (index == -1) {
            return 0;
        }
        if (Integer.parseInt(s.substring(index + 1)) == 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    public static int getNumberOfDecimalPlace(double value) {
        BigDecimal bigDecimal = new BigDecimal("" + value);
        String s = bigDecimal.toPlainString();
        System.out.println(s);
        int index = s.indexOf(46);
        if (index < 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    public static String bigDecimalToString(BigDecimal bigDecimal) {
        try {
            int point = BigDecimalUtils.getNumberOfDecimalPlace(bigDecimal);
            BigDecimal pointVal = BigDecimal.ONE;
            for (int i = 0; i < point; ++i) {
                pointVal = pointVal.divide(BigDecimal.TEN);
            }
            return bigDecimal.divide(pointVal).intValue() + "," + point;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static BigDecimal stringToBigDecimal(String str) {
        try {
            String[] split = str.split(",");
            int point = Integer.parseInt(split[1]);
            BigDecimal pointVal = BigDecimal.ONE;
            for (int i = 0; i < point; ++i) {
                pointVal = pointVal.divide(BigDecimal.TEN);
            }
            return new BigDecimal(split[0]).multiply(pointVal).setScale(point, 4);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BigDecimal stringToBigDecimalDefaultZero(String str) {
        BigDecimal result = BigDecimalUtils.stringToBigDecimal(str);
        return Objects.isNull(result) ? BigDecimal.ZERO : result;
    }

    static {
        unitConvert.put("\u91cd\u91cf", new BigDecimal("1000"));
        unitConvert.put("g", new BigDecimal("1"));
        unitConvert.put("kg", new BigDecimal("1000"));
        unitConvert.put("ton", new BigDecimal("1000000"));
        unitConvert.put("t", new BigDecimal("1000000"));
        unitConvert.put("lb", new BigDecimal("453.59237"));
        unitConvert.put("b", new BigDecimal("453.59237"));
        unitConvert.put("500g", new BigDecimal("500"));
        unitConvert.put("100g", new BigDecimal("100"));
        unitConvert.put("1/4lb", new BigDecimal("113.39809"));
        unitConvert.put("1/4b", new BigDecimal("113.39809"));
    }
}

