/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.utils.DateUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ByteUtils {
    private static final short UNSIGNED_MAX_VALUE = 255;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String hex2Ascii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static String ascii2Hex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString(ch));
        }
        return hex.toString();
    }

    public static String formatMark(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    public static String ten2two(int val, int length) {
        String binaryStr = Integer.toBinaryString(val);
        int lg = binaryStr.length();
        if (lg < length) {
            int cn = length - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    public static String inserE(String targe, int index, String str) {
        String res = "";
        for (int i = targe.length(); i > 0; --i) {
            if (targe.length() - i == index) {
                res = str + res;
            }
            res = targe.charAt(i - 1) + res;
        }
        return res;
    }

    public static String formatData(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            binaryStr = str + binaryStr;
        }
        return new StringBuffer(binaryStr).reverse().toString();
    }

    public static byte[] fromHexAscii(String s) throws NumberFormatException {
        try {
            int len = s.length();
            if (len % 2 != 0) {
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");
            }
            int out_len = len / 2;
            byte[] out = new byte[out_len];
            int i = 0;
            StringReader sr = new StringReader(s);
            while (i < out_len) {
                int val = 16 * ByteUtils.fromHexDigit(sr.read()) + ByteUtils.fromHexDigit(sr.read());
                out[i++] = (byte)val;
            }
            return out;
        }
        catch (IOException e) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    public static String toBinary(int length) {
        String str = Integer.toBinaryString(length);
        if (str.length() < 2) {
            str = length == 0 ? "01" : "0" + str;
        }
        return str;
    }

    private static int fromHexDigit(int c) throws NumberFormatException {
        if (c >= 48 && c < 58) {
            return c - 48;
        }
        if (c >= 65 && c < 71) {
            return c - 55;
        }
        if (c >= 97 && c < 103) {
            return c - 87;
        }
        throw new NumberFormatException(39 + c + "' is not a valid hexadecimal digit.");
    }

    public static String covert102Hex(String data) {
        Integer dInt = Integer.parseInt(data);
        String hexString = Integer.toHexString(dInt);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return ByteUtils.convert(hexString);
    }

    public static String convert(String hex) {
        return ByteUtils.toHexAscii(ByteUtils.reverse(ByteUtils.fromHexAscii(hex)));
    }

    public static String toHexAscii(byte[] bytes) {
        int len = bytes.length;
        StringWriter sw = new StringWriter(len * 2);
        for (int i = 0; i < len; ++i) {
            ByteUtils.addHexAscii(bytes[i], sw);
        }
        return sw.toString();
    }

    public static String toHexAscii(byte b) {
        StringWriter sw = new StringWriter(2);
        ByteUtils.addHexAscii(b, sw);
        return sw.toString();
    }

    private static void addHexAscii(byte b, StringWriter sw) {
        short ub = ByteUtils.toUnsigned(b);
        int h1 = ub / 16;
        int h2 = ub % 16;
        sw.write(ByteUtils.toHexDigit(h1));
        sw.write(ByteUtils.toHexDigit(h2));
    }

    private static short toUnsigned(byte b) {
        return (short)(b < 0 ? 256 + b : b);
    }

    private static char toHexDigit(int h) {
        char out = h <= 9 ? (char)(h + 48) : (char)(h + 55);
        return out;
    }

    public static byte[] reverse(byte[] bytes) {
        int len = bytes.length;
        byte[] newBytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            newBytes[i] = bytes[len - 1 - i];
        }
        return newBytes;
    }

    public static int[] reverse(int[] ints) {
        int len = ints.length;
        int[] newInts = new int[len];
        for (int i = 0; i < len; ++i) {
            newInts[i] = ints[len - 1 - i];
        }
        return newInts;
    }

    public static String int2HexWithPush(int val, int length) {
        return ByteUtils.convert(ByteUtils.int2HexWithPush_nr(val, length));
    }

    public static String fid(int fid) {
        return ByteUtils.int2HexWithPush(fid, 8);
    }

    public static String int2HexWithPush_nr(int val, int length) {
        String hex = Integer.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            int padding = length - hexLength;
            for (int i = 0; i < padding; ++i) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        return hex;
    }

    public static String long2Hex(long val, int length) {
        return ByteUtils.convert(ByteUtils.long2HexWithPush_nr(val, length));
    }

    public static String long2HexWithPush_nr(long val, int length) {
        String hex = Long.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            int padding = length - hexLength;
            for (int i = 0; i < padding; ++i) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        return hex;
    }

    public static String int2Hex(int val) {
        String hex = Integer.toHexString(val);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        hex = ByteUtils.convert(hex);
        return hex;
    }

    public static String dataFormat(String data) {
        String hexString = Integer.toHexString(Integer.parseInt(data, 2));
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static String a_text(String text) {
        text = StringUtils.isBlank((CharSequence)text) ? "" : text;
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return ByteUtils.toHexAscii(bytes) + "00";
    }

    public static String p_text(String content) {
        int index = ByteUtils.indexOf(content, "00");
        if (index == -1) {
            return null;
        }
        String text = new String(ByteUtils.fromHexAscii(content.substring(0, index + 2)), StandardCharsets.UTF_8).trim();
        return StringUtils.isNotBlank((CharSequence)text) ? text : null;
    }

    public static String string2HexUTF8(String strPart) {
        return ByteUtils.string2HexString(strPart, "UTF-8");
    }

    public static String string2HexString(String strPart, String tochartype) {
        try {
            return ByteUtils.bytes2HexString(strPart.getBytes(tochartype));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bytes2HexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            result.append(String.format("%02X", b[i]));
        }
        return result.toString();
    }

    public static String toHexString(byte[] var0) {
        String var1 = "";
        for (int var2 = 0; var2 < var0.length; ++var2) {
            var1 = var1 + HEX_CHARS[var0[var2] >>> 4 & 0xF];
            var1 = var1 + HEX_CHARS[var0[var2] & 0xF];
        }
        return var1.toUpperCase();
    }

    public static int indexOf(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; ++i) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (!st.equals(str)) continue;
            index = i * 2;
            break;
        }
        return index;
    }

    public static int indexOfWithStr(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; ++i) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (!st.equals(str)) continue;
            index = i * 2;
            break;
        }
        return index == -1 ? index : index + str.length();
    }

    public static BigDecimal hexBigDecimal(String hexString) {
        int floa = Integer.parseInt(hexString.substring(6, 8), 16);
        int val = Integer.parseInt(hexString.substring(0, 6), 16);
        int floatVal = ByteUtils.floatVal(floa);
        return BigDecimal.valueOf(val).divide(BigDecimal.valueOf(floatVal), floa, RoundingMode.HALF_UP);
    }

    public static int floatVal(int floa) {
        int floaVal = 1;
        for (int i = 0; i < floa; ++i) {
            floaVal *= 10;
        }
        return floaVal;
    }

    public static BigDecimal convertBigDecimal(String hexString) {
        String convert = ByteUtils.convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        return BigDecimal.valueOf(money >> 3, money & 7);
    }

    public static BigDecimal convertBigDecimalNone(String hexString) {
        if ("0000000F".equals(hexString)) {
            return null;
        }
        String convert = ByteUtils.convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        return BigDecimal.valueOf(money >> 3, money & 7);
    }

    public static String toSPFStr(BigDecimal d) {
        return ByteUtils.completeBytes(Long.toHexString(ByteUtils.toSPF2(d)), 8);
    }

    public static String toSPFStrNone(BigDecimal d) {
        return Objects.nonNull(d) ? ByteUtils.completeBytes(Long.toHexString(ByteUtils.toSPF2(d)), 8) : "0000000F";
    }

    public static int toSPF(BigDecimal d) {
        long A = d.multiply(new BigDecimal(10000000)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        int B = 7;
        while (true) {
            if (B == 0) {
                if (A >= 0x10000000L) {
                    A = 0xFFFFFFFL;
                    break;
                }
                if (A >= -268435456L) break;
                A = -268435456L;
                break;
            }
            if (A >= 0x10000000L || A < -268435456L) {
                A = A > 0L ? (A + 5L) / 10L : (A - 5L) / 10L;
                --B;
                continue;
            }
            if ((long)((int)(A / 10L) * 10) != A) break;
            A /= 10L;
            --B;
        }
        return (int)(A << 3 | (long)B);
    }

    public static int toSPF2(BigDecimal d) {
        int flot = BigDecimalUtils.getNumberOfDecimalPlace(d);
        int fv = 1;
        for (int i = 0; i < flot; ++i) {
            fv *= 10;
        }
        long A = d.multiply(BigDecimal.valueOf(fv)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        int B = flot;
        return (int)(A << 3 | (long)B);
    }

    public static byte[] fromHexString(String var0) {
        char[] var1 = var0.toUpperCase().toCharArray();
        int var2 = 0;
        for (int var3 = 0; var3 < var1.length; ++var3) {
            if ((var1[var3] < '0' || var1[var3] > '9') && (var1[var3] < 'A' || var1[var3] > 'F')) continue;
            ++var2;
        }
        byte[] var6 = new byte[var2 + 1 >> 1];
        int var4 = var2 & 1;
        for (int var5 = 0; var5 < var1.length; ++var5) {
            if (var1[var5] >= '0' && var1[var5] <= '9') {
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] | var1[var5] - 48);
            } else {
                if (var1[var5] < 'A' || var1[var5] > 'F') continue;
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] | var1[var5] - 65 + 10);
            }
            ++var4;
        }
        return var6;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static int[] byteMerger(int[] int_1, int[] int_2) {
        int[] int_3 = new int[int_1.length + int_2.length];
        System.arraycopy(int_1, 0, int_3, 0, int_1.length);
        System.arraycopy(int_2, 0, int_3, int_1.length, int_2.length);
        return int_3;
    }

    public static String[] byteMerger(String[] str_1, String[] str_2) {
        String[] str_3 = new String[str_1.length + str_2.length];
        System.arraycopy(str_1, 0, str_3, 0, str_1.length);
        System.arraycopy(str_2, 0, str_3, str_1.length, str_2.length);
        return str_3;
    }

    public static int[] removeMerger(int[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        int[] newArr = new int[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[j] = arr[i];
            ++j;
        }
        return newArr;
    }

    public static String[] removeMerger(String[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        String[] newArr = new String[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[j] = arr[i];
            ++j;
        }
        return newArr;
    }

    public static float[][] removeMerger(float[][] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        float[][] newArr = new float[arr.length - 1][];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[j] = arr[i];
            ++j;
        }
        return newArr;
    }

    public static float[] removeMerger(float[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        float[] newArr = new float[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[j] = arr[i];
            ++j;
        }
        return newArr;
    }

    public static String convertHex(String hex) {
        return ByteUtils.toHexAscii(ByteUtils.reverse(ByteUtils.fromHexString(hex)));
    }

    public static String completeBytes(Integer num, int length) {
        String hexNum = Integer.toHexString(num);
        return ByteUtils.completeBytes(hexNum, length * 2).toUpperCase();
    }

    public static String completeBytes(String content, int length) {
        int contenLength;
        if (content.length() % 2 != 0) {
            content = "0" + content;
        }
        if (length < (contenLength = (content = ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexString(content)))).length())) {
            return content.substring(0, length);
        }
        for (int i = 0; i < length - contenLength; ++i) {
            content = content + "0";
        }
        return content;
    }

    public static final LocalDateTime getStartTime() {
        return LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
    }

    public static String appendFill(String content) {
        String res = content;
        int lg = content.length() / 2;
        if (lg % 16 == 0) {
            return content;
        }
        int appendBit = 16 - lg % 16;
        if (appendBit != 0) {
            for (int i = 0; i < appendBit; ++i) {
                res = i == 0 ? res + "F0" : res + "00";
            }
        }
        return res;
    }

    public static String appendFill(String hexString, int length) {
        if (StringUtils.isBlank((CharSequence)hexString)) {
            return "";
        }
        if (length == -1) {
            if (hexString.length() % 2 != 0) {
                hexString = "0" + hexString;
            }
            return hexString;
        }
        if (hexString.length() >= length) {
            return hexString.substring(0, length);
        }
        int pantting = length - hexString.length();
        for (int i = 0; i < pantting; ++i) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static String appendFill(String hexString, char append, int length) {
        if (StringUtils.isBlank((CharSequence)hexString)) {
            return "";
        }
        if (hexString.length() >= length) {
            return hexString.substring(0, length);
        }
        int pantting = length - hexString.length();
        for (int i = 0; i < pantting; ++i) {
            hexString = append + hexString;
        }
        return hexString;
    }

    public static byte[] intToBytes(int a, int length) {
        byte[] bs = new byte[length];
        for (int i = bs.length - 1; i >= 0; --i) {
            bs[i] = (byte)(a % 255);
            a /= 255;
        }
        return bs;
    }

    public static byte[] intToBytes(int a) {
        return ByteUtils.intToBytes(a, 1);
    }

    public static int bytesToInt(byte[] bs) {
        int a = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            a = (int)((double)a + (double)bs[i] * Math.pow(255.0, bs.length - i - 1));
        }
        return a;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String long2Hex(long val) {
        String hex = Long.toHexString(val);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        hex = ByteUtils.convert(hex);
        return hex;
    }

    public static Integer pointToInteger(BigDecimal val, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; ++i) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        return val.multiply(standby).intValue();
    }

    public static Long pointToLong(BigDecimal val, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; ++i) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        return val.multiply(standby).longValue();
    }

    public static BigDecimal integerToPoint(Integer val, boolean lessZero, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; ++i) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        BigDecimal result = new BigDecimal(val.toString()).divide(standby);
        return lessZero ? BigDecimalUtils.reverse(result) : result;
    }

    public static BigDecimal longToPoint(Long val, boolean lessZero, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; ++i) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        BigDecimal result = new BigDecimal(val.toString()).divide(standby);
        return lessZero ? BigDecimalUtils.reverse(result) : result;
    }

    public static String bigDecimalToStr(BigDecimal amount) {
        try {
            boolean lessZeroValue = BigDecimalUtils.compareLessZeroValue(amount);
            if (lessZeroValue) {
                amount = BigDecimalUtils.reverse(amount);
            }
            double v = amount.setScale(4, 4).doubleValue();
            String vs = String.valueOf(v);
            int point = 0;
            if (v != 0.0) {
                point = vs.length() - vs.lastIndexOf(".") - 1;
            }
            return Integer.toHexString(point) + (lessZeroValue ? (char)'1' : '0') + ByteUtils.appendFill(Integer.toHexString(ByteUtils.pointToInteger(new BigDecimal(vs), point)), 6);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String bigDecimalToStr2(BigDecimal amount) {
        try {
            boolean lessZeroValue = BigDecimalUtils.compareLessZeroValue(amount);
            if (lessZeroValue) {
                amount = BigDecimalUtils.reverse(amount);
            }
            StringBuilder builder = new StringBuilder();
            if (ByteUtils.isInteger(amount)) {
                builder.append(0).append(lessZeroValue ? (char)'1' : '0').append(ByteUtils.appendFill(amount.toBigInteger().toString(16), 14));
            } else {
                builder.append(amount.scale()).append(lessZeroValue ? (char)'1' : '0').append(ByteUtils.appendFill(Long.toHexString(ByteUtils.pointToLong(new BigDecimal(amount.toPlainString()), amount.scale())), 14));
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isInteger(BigDecimal value) {
        return value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public static BigDecimal strToBigDecimal(String str) {
        try {
            return ByteUtils.longToPoint(Long.parseLong(str.substring(2), 16), '1' == str.charAt(1), Integer.parseInt(String.valueOf(str.charAt(0)), 16));
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static String timeToStrNoConvert(Date date) {
        return ByteUtils.timeToStr((Objects.isNull(date) ? new Date() : date).getTime());
    }

    public static String timeToStr(Date date) {
        return ByteUtils.convert(ByteUtils.timeToStr((Objects.isNull(date) ? new Date() : date).getTime()));
    }

    public static String timeToStrNone(Date date) {
        return Objects.nonNull(date) ? ByteUtils.convert(ByteUtils.timeToStr(date.getTime())) : "FFFFFFFF";
    }

    public static String timeToStr(long time) {
        long sys_time = DateUtils.getDefaultTime().getTime();
        time = Math.max(time, sys_time);
        time = (time - sys_time) / 1000L;
        return ByteUtils.appendFill(Long.toHexString(time), 8);
    }

    public static Date convertTime(String hexString) {
        long time = Long.parseLong(ByteUtils.convert(hexString), 16);
        return new Date((time + 946656000L) * 1000L);
    }

    public static Date convertTimeNone(String hexString) {
        if ("FFFFFFFF".equals(hexString)) {
            return null;
        }
        long time = Long.parseLong(ByteUtils.convert(hexString), 16);
        return new Date((time + 946656000L) * 1000L);
    }

    public static Date convertTime_nr(String hexString) {
        long time = Long.parseLong(hexString, 16);
        return new Date((time + 946656000L) * 1000L);
    }

    public static long strToTimeMillis(String str) {
        long sys_time = DateUtils.getDefaultTime().getTime();
        return Long.parseLong(str, 16) * 1000L + sys_time;
    }

    public static Date strToDate(String str) {
        return new Date(ByteUtils.strToTimeMillis(str));
    }

    public static String txtToStr(String txt) {
        String str = "";
        if (StringUtils.isNotBlank((CharSequence)txt)) {
            str = ByteUtils.toHexAscii(txt.getBytes(DConstant.DEFAULT_CHARSET));
        }
        return str;
    }

    public static String txtToStr_UTF8(String txt) {
        String str = "";
        if (StringUtils.isNotBlank((CharSequence)txt)) {
            str = ByteUtils.toHexAscii(txt.getBytes(DConstant.UTF_8));
        }
        return str;
    }

    public static String strToTxt(String str) {
        String txt = "";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.endsWith("00") ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.DEFAULT_CHARSET);
        }
        return txt;
    }

    public static String strToTxt_UTF8(String str) {
        String txt = "";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.endsWith("00") ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.UTF_8);
        }
        return txt;
    }

    public static String binaryToHex(String binary) {
        return ByteUtils.int2Hex(Integer.parseInt(binary, 2));
    }

    public static String binary2Hex(String binary) {
        BigInteger binaryVal = new BigInteger(binary, 2);
        String hex = binaryVal.toString(16);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        return ByteUtils.convert(hex);
    }

    public static String binaryToHex(String binary, int length) {
        return ByteUtils.int2HexWithPush(Integer.parseInt(binary, 2), length);
    }

    public static String hexToBinary(String hex) {
        return ByteUtils.ten2two(Integer.parseInt(ByteUtils.convert(hex), 16), 8);
    }

    public static String hex2Binary(String hex) {
        BigInteger hexVal = new BigInteger(ByteUtils.convert(hex), 16);
        return hexVal.toString(2);
    }

    public static String hexToBinary(String hex, int length) {
        return ByteUtils.ten2two(Integer.parseInt(ByteUtils.convert(hex), 16), length);
    }

    public static String tryParseToString(String toParse) {
        return StringUtils.isNotBlank((CharSequence)toParse) ? toParse.replace('\n', '\u000b') : "";
    }

    public static String tryParseFromString(String toParse) {
        return StringUtils.isNotBlank((CharSequence)toParse) ? toParse.replace('\u000b', '\n') : "";
    }

    public static String strMaxLength(String str, int length) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static String stringInvert(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            String target = "";
            for (int i = source.length(); i > 0; --i) {
                target = target + source.charAt(i - 1);
            }
            return target;
        }
        return source;
    }

    public static boolean isHex(String hex) {
        try {
            return StringUtils.isNotBlank((CharSequence)hex) && Long.parseLong(hex, 16) > -1L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int hex2Ten(String hex) {
        return Integer.parseInt(ByteUtils.convert(hex), 16);
    }

    public static long hex2Long(String hex) {
        return Long.parseLong(ByteUtils.convert(hex), 16);
    }

    public static String completeEnd(String content, int length) {
        int append = length - (content = StringUtils.isNotBlank((CharSequence)content) ? content : "").length();
        if (append > 0) {
            for (int i = 0; i < append; ++i) {
                content = content + "0";
            }
            return content;
        }
        return content.substring(0, length);
    }

    public static boolean isGiveForever(BigDecimal giveBalance, Date giveTime) {
        return Objects.nonNull(giveBalance) && BigDecimalUtils.compareMoreZeroValue(giveBalance) && (Objects.isNull(giveTime) || DateUtils.TIME_2000_1_1_0_0_0.longValue() == giveTime.getTime());
    }

    public static String strToTxt2(String str) {
        String txt = "";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.endsWith("00") ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.UTF_8);
        }
        return txt;
    }

    public static String timeToHex(Date date) {
        long timeDefault = DateUtils.TIME_2000_1_1_0_0_0;
        long timeLong = date.getTime();
        long seconds = (timeLong - timeDefault) / 1000L;
        return ByteUtils.completeBytes(Long.toHexString(seconds), 8).toUpperCase();
    }

    public static Date hexToTime(String hex) {
        long seconds = Long.parseLong(ByteUtils.convert(hex), 16) * 1000L;
        long timeDefault = DateUtils.TIME_2000_1_1_0_0_0;
        long timeLong = seconds + timeDefault;
        return new Date(timeLong);
    }
}

