/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.io.UnsupportedEncodingException;

public class CharTools {
    public static final String ISO2GB(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("ISO-8859-1"), "GB2312");
        }
        catch (UnsupportedEncodingException ex) {
            result = ex.toString();
        }
        return result;
    }

    public static final String GB2ISO(String text) {
        String result = "";
        try {
            result = new String(text.getBytes("GB2312"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static final String Utf8URLencode(String text) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                result.append(c);
                continue;
            }
            byte[] b = new byte[]{};
            try {
                b = Character.toString(c).getBytes("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                result.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return result.toString();
    }

    public static final String Utf8URLdecode(String text) {
        String result = "";
        int p = 0;
        if (text != null && text.length() > 0) {
            p = (text = text.toLowerCase()).indexOf("%e");
            if (p == -1) {
                return text;
            }
            while (p != -1) {
                result = result + text.substring(0, p);
                if ((text = text.substring(p, text.length())) == "" || text.length() < 9) {
                    return result;
                }
                result = result + CharTools.CodeToWord(text.substring(0, 9));
                text = text.substring(9, text.length());
                p = text.indexOf("%e");
            }
        }
        return result + text;
    }

    private static final String CodeToWord(String text) {
        String result;
        if (CharTools.Utf8codeCheck(text)) {
            byte[] code = new byte[]{(byte)(Integer.parseInt(text.substring(1, 3), 16) - 256), (byte)(Integer.parseInt(text.substring(4, 6), 16) - 256), (byte)(Integer.parseInt(text.substring(7, 9), 16) - 256)};
            try {
                result = new String(code, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                result = null;
            }
        } else {
            result = text;
        }
        return result;
    }

    private static final boolean Utf8codeCheck(String text) {
        String sign = "";
        if (text.startsWith("%e")) {
            int i = 0;
            int p = 0;
            while (p != -1) {
                if ((p = text.indexOf("%", p)) != -1) {
                    ++p;
                }
                sign = sign + p;
                ++i;
            }
        }
        return sign.equals("147-1");
    }

    public static final boolean isUtf8Url(String text) {
        int p = (text = text.toLowerCase()).indexOf("%");
        if (p != -1 && text.length() - p > 9) {
            text = text.substring(p, p + 9);
        }
        return CharTools.Utf8codeCheck(text);
    }
}

