/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClazzUtils {
    private ClazzUtils() {
    }

    public static Map<String, Field> getAllFields(Class clazz) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] selfFields = clazz.getDeclaredFields();
        if (selfFields != null && selfFields.length > 0) {
            for (Field field : selfFields) {
                fieldMap.put(field.getName(), field);
            }
        }
        while (clazz != Object.class) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                fieldMap.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldMap;
    }

    public static <T> T getObjectVal(Object obj, Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Field[] declaredFields = obj.getClass().getDeclaredFields();
            if (declaredFields != null && declaredFields.length > 0) {
                for (Field declaredField : declaredFields) {
                    if (!declaredField.getType().equals(clazz)) continue;
                    declaredField.setAccessible(true);
                    return (T)declaredField.get(obj);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field getObjectField(Object obj, Class clazz) {
        if (clazz == null) {
            return null;
        }
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        if (declaredFields != null && declaredFields.length > 0) {
            for (Field declaredField : declaredFields) {
                if (!declaredField.getType().equals(clazz)) continue;
                return declaredField;
            }
        }
        return null;
    }

    public static <T> T getObjectVal(Object obj, String name, Class<T> clazz) {
        try {
            if (clazz == null) {
                return null;
            }
            Field declaredField = obj.getClass().getDeclaredField(name);
            declaredField.setAccessible(true);
            return (T)declaredField.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getKeyVal(Object obj) {
        HashMap<String, Object> map = null;
        if (Objects.nonNull(obj)) {
            map = new HashMap<String, Object>();
            Field[] fields = obj.getClass().getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        map.put(field.getName(), field.get(obj));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return map;
    }
}

