/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteAsk;
import com.jhscale.common.model.device._inner.PublicExecuteDelete;
import com.jhscale.common.model.device._inner.PublicExecuteEnd;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.device._inner.PublicExecuteModifyCache;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.model.device._inner.UnPackageResponse;
import com.jhscale.common.model.device.ai_feature.DAIFeatureV1;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV1;
import com.jhscale.common.model.device.bitmap.DBitMapV1;
import com.jhscale.common.model.device.category.DCategoryV1;
import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.device.font.DFontV1;
import com.jhscale.common.model.device.info.DDeviceInfo;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.DTIM;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INI;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.model.device.label_format.DLabelFormatV1;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.common.model.device.other.DSpDWLV1;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscount;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.salejob.DSaleJobV1;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.device.shortkey.DShortKeyV1;
import com.jhscale.common.model.device.shortpage.DShortPageV1;
import com.jhscale.common.model.device.shortpage_formwork.DShortPageFormworkV1;
import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.DDataExecute;
import com.jhscale.common.utils.GZIPUtils;
import com.jhscale.common.utils.JSONUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DDataUtils {
    private static DDataExecute dataExecute = null;
    private static final List<String> Valid_Field_Top = Arrays.asList("DWL", "CLR", "UPL", "ASK");
    private static Map<Class<? extends DataJSONModel>, List<Field>> DataJSONModelFieldMap = new HashMap<Class<? extends DataJSONModel>, List<Field>>();

    private DDataUtils() {
    }

    public static void setDataExecute(DDataExecute dataExecute) {
        DDataUtils.dataExecute = dataExecute;
    }

    public static DDataExecute getDataExecute() {
        return dataExecute;
    }

    public static Integer getSpDWL(String key) {
        return DDataUtils.getDataExecute() != null ? DDataUtils.getDataExecute().getSpDWL(key) : null;
    }

    @Deprecated
    public static <T> Integer getResultInteger(T t) {
        return Objects.isNull(t) ? null : Integer.valueOf(Integer.parseInt(String.valueOf(t)));
    }

    @Deprecated
    public static <T> BigDecimal getResultBigDecimal(T t) {
        return Objects.isNull(t) ? null : new BigDecimal(String.valueOf(t));
    }

    @Deprecated
    public static List<DManualDiscount> getDManualDiscount(String manualDiscount) {
        ArrayList<DManualDiscount> manualDiscountList = new ArrayList<DManualDiscount>();
        if (StringUtils.isBlank((CharSequence)manualDiscount)) {
            return null;
        }
        String[] split = StringUtils.split((String)manualDiscount, (String)"|");
        if (Objects.isNull(split) && split.length <= 0) {
            return null;
        }
        String dmanualDiscounts = split[0];
        String[] dmanualDiscountss = dmanualDiscounts.split("#");
        String upperLimit = dmanualDiscountss[0];
        String lowerLimit = dmanualDiscountss[1];
        String manualDiscountTypes = split[1];
        String[] manualDiscountTypess = manualDiscountTypes.split("#");
        String upperDiscountType = manualDiscountTypess[0];
        String lowerDiscountType = manualDiscountTypess[1];
        String discounts = split[2];
        String[] discountss = discounts.split("#");
        String upperValue = discountss[0];
        String lowerValue = discountss[1];
        manualDiscountList.add(new DManualDiscount().setDiscount(DDataUtils.getResultInteger(upperLimit), DDataUtils.getResultInteger(upperDiscountType), DDataUtils.getResultBigDecimal(upperValue)));
        manualDiscountList.add(new DManualDiscount().setDiscount(DDataUtils.getResultInteger(lowerLimit), DDataUtils.getResultInteger(lowerDiscountType), DDataUtils.getResultBigDecimal(lowerValue)));
        return manualDiscountList;
    }

    @Deprecated
    public static DAutoDiscount getAutoDiscount(String autoDiscount) {
        if (StringUtils.isBlank((CharSequence)autoDiscount)) {
            return null;
        }
        DAutoDiscount dAutoDiscount = new DAutoDiscount();
        String[] split = StringUtils.split((String)autoDiscount, (String)"#");
        String discountType = split[0];
        String activation = split[1];
        String min = split[2];
        String max = split[3];
        String discountValue = split[4];
        String intervalType = null;
        if (split.length > 5) {
            intervalType = split[5];
        }
        return dAutoDiscount.setType(DDataUtils.getResultInteger(discountType)).setDate(DDataUtils.getResultInteger(activation)).setLower(DDataUtils.getResultBigDecimal(min)).setUpper(DDataUtils.getResultBigDecimal(max)).setDiscount(DDataUtils.getResultBigDecimal(discountValue)).setIntervalType(DDataUtils.getResultInteger(intervalType));
    }

    @Deprecated
    private static List<DAutoDiscount> getAutoDiscount(String ... autoDiscount) {
        if (Objects.isNull(autoDiscount) || autoDiscount.length == 0) {
            return null;
        }
        ArrayList<DAutoDiscount> autoDiscountList = new ArrayList<DAutoDiscount>();
        Arrays.stream(autoDiscount).forEach(i -> autoDiscountList.add(DDataUtils.getAutoDiscount(i)));
        return autoDiscountList;
    }

    @Deprecated
    public static <T extends DataJSONModel> String gzip(T ... models) {
        return DDataUtils.gzip(models);
    }

    @Deprecated
    public static <T extends DataJSONModel> String gzip(List<T> models) {
        return GZIPUtils.compress(JSONUtils.objectToJSON(models));
    }

    @Deprecated
    public static <T extends DataJSONModel> List<T> ungzip(String content, Class<T> clazz) {
        return JSONUtils.jsonToList(GZIPUtils.uncompress(content), clazz);
    }

    @Deprecated
    public static <T extends DataJSONModel> String assemble(T ... models) {
        return DDataUtils.assemble((boolean)true, models);
    }

    @Deprecated
    public static <T extends DataJSONModel> String assemble(List<T> models) {
        return DDataUtils.assemble(true, models);
    }

    @Deprecated
    public static <T extends DataJSONModel> String assemble(boolean base64, T ... models) {
        return DDataUtils.assemble(base64, Arrays.asList(models));
    }

    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(T ... models) {
        return DDataUtils.assembleArr(true, Arrays.asList(models));
    }

    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(List<T> models) {
        return DDataUtils.assembleArr(true, models);
    }

    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(boolean base64, T ... models) {
        return DDataUtils.assembleArr(base64, Arrays.asList(models));
    }

    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(boolean base64, List<T> models) {
        return Optional.ofNullable(models).orElse(Collections.emptyList()).stream().map(model -> DDataUtils.assemble((boolean)base64, (DataJSONModel[])new DataJSONModel[]{model})).collect(Collectors.toList());
    }

    @Deprecated
    public static <T extends DataJSONModel> String assemble(boolean base64, List<T> models) {
        if (models != null && !models.isEmpty()) {
            StringBuffer buffer = new StringBuffer().append(((DataJSONModel)models.get(0)).getClass().getName()).append("\u03c9\u03c9");
            for (DataJSONModel model : models) {
                buffer.append(model.assemble(false)).append("\u03c6");
            }
            String result = buffer.substring(0, buffer.length() - "\u03c6".length());
            return base64 ? Base64Utils.gzipString(result) : result;
        }
        return null;
    }

    public static <T extends DataJSONModel> List<T> analyze(String content) throws ProfessionalException {
        return DDataUtils.analyze(content, true);
    }

    public static <T extends DataJSONModel> List<T> analyze(String content, boolean base64) throws ProfessionalException {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String string = content = base64 ? Base64Utils.ungzipString(content) : content;
            if (content.contains("\u03c9\u03c9")) {
                String[] strArr;
                String[] contentArr = content.split("\u03c9\u03c9");
                Class<?> aClass = null;
                try {
                    aClass = Class.forName(contentArr[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aClass == null) {
                    throw new ProfessionalException(GeneralInternational.\u672a\u627e\u5230\u5bf9\u8c61\u4fe1\u606f);
                }
                ArrayList dataList = new ArrayList();
                for (String str : strArr = contentArr[1].split("\u03c6")) {
                    Object data = null;
                    try {
                        data = aClass.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dataList.add(((DataJSONModel)data).parse(str, false));
                }
                return dataList;
            }
        }
        return null;
    }

    public static boolean isNew(String data, boolean base64) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            data = base64 ? Base64Utils.ungzipString(data) : data;
            return data.contains("\u03c9\u03c9");
        }
        return false;
    }

    public static <T extends DataJSONModel> T analyze(String content, boolean uncompress, Class<T> clazz) {
        return (T)(uncompress ? (DataJSONModel)JSONUtils.jsonToObject(GZIPUtils.uncompress(content), clazz) : (DataJSONModel)JSONUtils.jsonToObject(content, clazz));
    }

    public static <T extends DataJSONModel> T analyze(String content, Class<T> clazz) {
        return DDataUtils.analyze(content, true, clazz);
    }

    public static String Public_Start(DataJSONModel jsonModel, int mark) {
        DataClass annotation;
        StringBuffer buffer = new StringBuffer();
        if (jsonModel != null && (annotation = jsonModel.getClass().getAnnotation(DataClass.class)) != null) {
            switch (mark) {
                case 1: {
                    buffer.append("DWL").append(annotation.separator()).append(annotation.mark()).append(annotation.line());
                    break;
                }
                case 2: {
                    buffer.append("CLR").append(annotation.separator()).append(annotation.mark()).append(annotation.line());
                    break;
                }
                case 3: {
                    buffer.append("UPL").append(annotation.separator()).append(annotation.mark()).append(annotation.line());
                    break;
                }
                case 4: {
                    if (!annotation.ask()) break;
                    buffer.append("ASK").append(annotation.separator()).append(annotation.mark()).append(annotation.line());
                }
            }
        }
        return buffer.toString();
    }

    public static String Public_End(DataJSONModel jsonModel) {
        DataClass annotation;
        StringBuffer buffer = new StringBuffer();
        if (jsonModel != null && (annotation = jsonModel.getClass().getAnnotation(DataClass.class)) != null) {
            return buffer.append("END").append(annotation.separator()).append(annotation.mark()).append(annotation.separator()).toString();
        }
        return buffer.toString();
    }

    public static List<PublicExecute> Public_UnPackage(String all_package) {
        return DDataUtils.Public_UnPackage_Reflex(all_package, false);
    }

    public static List<PublicExecute> Public_UnPackage_Reflex(String all_package, boolean reflex) {
        ArrayList<PublicExecute> publicExecutes = new ArrayList<PublicExecute>();
        String[] lines = all_package.split("\r\n");
        PublicExecute execute = null;
        int serial = 0;
        for (String line : lines) {
            if (!StringUtils.isNotBlank((CharSequence)line)) continue;
            String[] all_fields = (line + "\r\n").split("\t");
            if (Valid_Field_Top.contains(all_fields[0])) {
                if (execute != null && !all_fields[0].equals(execute.getExecute())) {
                    publicExecutes.add(execute);
                    execute = null;
                }
                block6 : switch (all_fields[0]) {
                    case "DWL": {
                        execute = new PublicExecuteModify(all_fields[1]);
                        break;
                    }
                    case "CLR": {
                        if (execute != null && execute.valid() && !execute.getType().equals(all_fields[1])) {
                            execute.setSerial(serial);
                            publicExecutes.add(execute);
                            execute = null;
                        }
                        PublicExecute publicExecute = execute = execute == null ? new PublicExecuteDelete(all_fields[1]) : execute;
                        if (all_fields.length != 4 || !StringUtils.isNotBlank((CharSequence)all_fields[2])) break;
                        ((PublicExecuteDelete)execute).add(Integer.parseInt(all_fields[2]));
                        break;
                    }
                    case "UPL": {
                        if (execute != null && execute.valid() && !execute.getType().equals(all_fields[1])) {
                            execute.setSerial(serial);
                            publicExecutes.add(execute);
                            execute = null;
                        }
                        PublicExecute publicExecute = execute = execute == null ? new PublicExecuteRecovery(all_fields[1]) : execute;
                        if (all_fields.length == 4 && StringUtils.isNotBlank((CharSequence)all_fields[2])) {
                            ((PublicExecuteRecovery)execute).add(Integer.parseInt(all_fields[2]));
                        }
                        switch (execute.getType()) {
                            case "INF": {
                                publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                execute = null;
                                break block6;
                            }
                            case "MAC": {
                                publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                execute = null;
                                break block6;
                            }
                            case "TIM": {
                                publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                execute = null;
                            }
                        }
                        break;
                    }
                    case "ASK": {
                        execute = new PublicExecuteAsk(all_fields[1]);
                    }
                }
                continue;
            }
            if ("END".equals(all_fields[0]) || all_fields.length > 1 && "END".equals(all_fields[1])) {
                if (execute != null && execute.valid()) {
                    execute.setSerial(serial);
                    publicExecutes.add(execute);
                }
                if (execute == null) continue;
                execute = null;
                continue;
            }
            if (execute != null) {
                DataJSONModel model = null;
                switch (all_fields[0]) {
                    case "INA": {
                        model = execute.remove_first(DDeviceInfoV1.class);
                        DDeviceInfo_INA ina = (DDeviceInfo_INA)new DDeviceInfo_INA().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        ((DDeviceInfo)model).setIna(ina);
                        break;
                    }
                    case "INM": {
                        model = execute.remove_first(DDeviceInfoV1.class);
                        DDeviceInfo_INM inm = (DDeviceInfo_INM)new DDeviceInfo_INM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        ((DDeviceInfo)model).setInm(inm);
                        break;
                    }
                    case "INF": {
                        model = execute.remove_first(DDeviceInfoV1.class);
                        DDeviceInfo_INF inf = (DDeviceInfo_INF)new DDeviceInfo_INF().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        ((DDeviceInfo)model).setInf(inf);
                        break;
                    }
                    case "INI": {
                        model = execute.remove_first(DDeviceInfoV1.class);
                        DDeviceInfo_INI ini = (DDeviceInfo_INI)new DDeviceInfo_INI().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        ((DDeviceInfo)model).setIni(ini);
                        break;
                    }
                    case "TIM": {
                        model = new DTIM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        break;
                    }
                    default: {
                        serial = all_fields.length;
                        if (reflex) {
                            model = DDataUtils.Public_UnPackage(all_fields);
                            break;
                        }
                        model = DDataUtils.typeToModel(all_fields[0]);
                        if (model == null) break;
                        model.Public_UnPackage_No_Reflex(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    }
                }
                if (model == null || !(execute instanceof PublicExecuteModify)) continue;
                ((PublicExecuteModify)execute).add(model);
                continue;
            }
            execute = DDataUtils.Public_UnPackage_Line(line);
        }
        if (execute != null) {
            publicExecutes.add(execute);
        }
        return publicExecutes;
    }

    public static List<PublicExecute> Public_UnPackage_Lines(String all_package) {
        ArrayList<PublicExecute> executes = new ArrayList<PublicExecute>();
        if (StringUtils.isNotBlank((CharSequence)all_package)) {
            String[] lines;
            for (String line : lines = all_package.split("\r\n")) {
                PublicExecute execute = DDataUtils.Public_UnPackage_Line(line);
                if (execute == null) continue;
                executes.add(execute);
            }
        }
        return executes;
    }

    public static UnPackageResponse Public_UnPackage_End_Lines(String all_package) {
        return DDataUtils.Public_UnPackage_End_Lines(all_package, false);
    }

    public static UnPackageResponse Public_UnPackage_End_Lines(String all_package, boolean log) {
        ArrayList<PublicExecute> executes = new ArrayList<PublicExecute>();
        String surplus = "";
        if (StringUtils.isNotBlank((CharSequence)all_package)) {
            int index = 0;
            while (index != -1) {
                long start = System.currentTimeMillis();
                index = all_package.indexOf("\r\n");
                long index_time = System.currentTimeMillis();
                if (index != -1) {
                    long split_time;
                    String line = all_package.substring(0, index);
                    long un_package_time = split_time = System.currentTimeMillis();
                    if (StringUtils.isNotBlank((CharSequence)line)) {
                        PublicExecute execute = DDataUtils.Public_UnPackage_Line(line);
                        un_package_time = System.currentTimeMillis();
                        if (execute != null) {
                            executes.add(execute);
                        }
                    }
                    all_package = all_package.substring(index + "\r\n".length());
                    long surplus_time = System.currentTimeMillis();
                    if (!log) continue;
                    System.out.println(String.format("All:[%s], index:[%s], split:[%s], un_package:[%s], surplus:[%s]", surplus_time - start, index_time - start, split_time - index_time, un_package_time - split_time, surplus_time - un_package_time));
                    continue;
                }
                surplus = StringUtils.isNotBlank((CharSequence)all_package) ? all_package : "";
            }
        }
        return new UnPackageResponse(executes, surplus);
    }

    public static PublicExecute Public_UnPackage_Line(String line) {
        PublicExecute execute = null;
        int serial = 0;
        if (StringUtils.isNotBlank((CharSequence)line)) {
            String[] all_fields = line.split("\t");
            serial = all_fields.length;
            switch (all_fields[0]) {
                case "DWL": {
                    break;
                }
                case "CLR": {
                    if (!"END".equals(all_fields[1])) {
                        execute = all_fields.length == 3 ? new PublicExecuteDelete(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteDelete(all_fields[1]);
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "UPL": {
                    if (!"END".equals(all_fields[1])) {
                        execute = all_fields.length == 3 ? new PublicExecuteRecovery(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteRecovery(all_fields[1]);
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "ASK": {
                    if (!"END".equals(all_fields[1])) {
                        execute = new PublicExecuteAsk(all_fields[1]);
                        ((PublicExecuteAsk)execute).add(Arrays.copyOfRange(all_fields, 2, all_fields.length));
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "END": {
                    execute = new PublicExecuteEnd(all_fields[1]);
                    break;
                }
                case "INA": {
                    DDeviceInfo_INA ina = (DDeviceInfo_INA)new DDeviceInfo_INA().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INA", ina);
                    break;
                }
                case "INM": {
                    DDeviceInfo_INM inm = (DDeviceInfo_INM)new DDeviceInfo_INM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INM", inm);
                    break;
                }
                case "INF": {
                    DDeviceInfo_INF inf = (DDeviceInfo_INF)new DDeviceInfo_INF().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INM", inf);
                    break;
                }
                case "INI": {
                    DDeviceInfo_INI ini = (DDeviceInfo_INI)new DDeviceInfo_INI().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INI", ini);
                    break;
                }
                case "TIM": {
                    DTIM tim = (DTIM)new DTIM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("TIM", tim);
                    break;
                }
                default: {
                    DataJSONModel jsonModel = DDataUtils.Public_UnPackage(all_fields);
                    if (jsonModel == null) break;
                    if (jsonModel instanceof DSpDWL) {
                        execute = new PublicExecuteModify(((DSpDWL)jsonModel).getKey(), jsonModel);
                        break;
                    }
                    DataClass annotation = jsonModel.getClass().getAnnotation(DataClass.class);
                    execute = new PublicExecuteModify(annotation.mark(), jsonModel);
                }
            }
        }
        if (execute != null) {
            execute.setSerial(serial);
        }
        return execute;
    }

    public static DataJSONModel Public_UnPackage(String[] all_fields) {
        DSpDWLV1 model = null;
        switch (all_fields[0]) {
            case "TMS": {
                model = (DSpDWLV1)new DDataParameterV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "TMT": {
                model = (DSpDWLV1)new DTextParameterV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "CLS": {
                model = (DSpDWLV1)new DCategoryV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "PLU": {
                model = (DSpDWLV1)new DPLUV5().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "BAR": {
                model = (DSpDWLV1)new DBarcodeFormatV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "LAT": {
                model = (DSpDWLV1)new DLabelFormatV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "SAJ": {
                model = (DSpDWLV1)new DSaleJobV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "SAL": {
                model = (DSpDWLV1)new DSaleManV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "SCP": {
                model = (DSpDWLV1)new DShortKeyV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "SCG": {
                model = (DSpDWLV1)new DShortPageV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "SGF": {
                model = (DSpDWLV1)new DShortPageFormworkV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "BMP": {
                model = (DSpDWLV1)new DBitMapV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "FNT": {
                model = (DSpDWLV1)new DFontV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            case "REP": {
                model = (DSpDWLV1)new DLOGV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            }
            default: {
                Integer spDWL;
                if (dataExecute == null || (spDWL = dataExecute.getSpDWL(all_fields[0])) == null) break;
                model = new DSpDWLV1();
                model.Public_UnPackage_No_Reflex(all_fields);
            }
        }
        return model;
    }

    public static String Public_Package(PublicExecute ... executes) {
        return DDataUtils.Public_Package(Arrays.asList(executes));
    }

    public static String Public_Package(List<PublicExecute> executes) {
        return DDataUtils.Public_Package_Reflex(executes, false);
    }

    public static String Public_Package_Reflex(List<PublicExecute> executes, boolean reflex) {
        StringBuffer buffer = new StringBuffer();
        if (executes != null && !executes.isEmpty()) {
            for (PublicExecute execute : executes) {
                if (reflex) {
                    buffer.append(execute.Package());
                    continue;
                }
                buffer.append(execute.Package_No_Reflex());
            }
        }
        return buffer.toString();
    }

    public static String Public_Package_No_Reflex(List<PublicExecute> executes) {
        StringBuffer buffer = new StringBuffer();
        if (executes != null && !executes.isEmpty()) {
            for (PublicExecute execute : executes) {
                buffer.append(execute.Package_No_Reflex());
            }
        }
        return buffer.toString();
    }

    public static String Public_Package_No_Reflex(PublicExecute ... executes) {
        return executes != null && executes.length > 0 ? DDataUtils.Public_Package_No_Reflex(Arrays.asList(executes)) : "";
    }

    public static UnPackageResponse Public_UnPackage_Lines_Distribute(String all_package) {
        return DDataUtils.Public_UnPackage_Lines_Distribute(all_package, false);
    }

    public static UnPackageResponse Public_UnPackage_Lines_Distribute(String all_package, boolean log) {
        ArrayList<PublicExecute> executes = new ArrayList<PublicExecute>();
        String surplus = "";
        if (StringUtils.isNotBlank((CharSequence)all_package)) {
            int index = 0;
            while (index != -1) {
                long start = System.currentTimeMillis();
                int len = "\r\n".length();
                index = -1;
                if (index == -1) {
                    len = "\n".length();
                    index = all_package.indexOf("\n");
                }
                long index_time = System.currentTimeMillis();
                if (index != -1) {
                    long split_time;
                    String line = all_package.substring(0, index + len);
                    long un_package_time = split_time = System.currentTimeMillis();
                    if (StringUtils.isNotBlank((CharSequence)line)) {
                        PublicExecute execute = DDataUtils.Public_UnPackage_Line_Distribute(line);
                        un_package_time = System.currentTimeMillis();
                        if (execute != null) {
                            executes.add(execute);
                        }
                    }
                    all_package = all_package.substring(index + len);
                    long surplus_time = System.currentTimeMillis();
                    if (!log) continue;
                    System.out.printf("Distribute All:[%s], index:[%s], split:[%s], un_package:[%s], surplus:[%s]%n", surplus_time - start, index_time - start, split_time - index_time, un_package_time - split_time, surplus_time - un_package_time);
                    continue;
                }
                surplus = StringUtils.isNotBlank((CharSequence)all_package) ? all_package : "";
            }
        }
        return new UnPackageResponse(executes, surplus);
    }

    public static PublicExecute Public_UnPackage_Line_Distribute(String line) {
        PublicExecute execute = null;
        int serial = 0;
        if (StringUtils.isNotBlank((CharSequence)line)) {
            String[] all_fields = line.split("\t");
            serial = all_fields.length;
            switch (all_fields[0]) {
                case "DWL": {
                    break;
                }
                case "CLR": {
                    if (!"END".equals(all_fields[1])) {
                        execute = all_fields.length == 4 ? new PublicExecuteDelete(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteDelete(all_fields[1]);
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "UPL": {
                    if (!"END".equals(all_fields[1])) {
                        execute = all_fields.length == 4 ? new PublicExecuteRecovery(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteRecovery(all_fields[1]);
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "ASK": {
                    if (!"END".equals(all_fields[1])) {
                        execute = new PublicExecuteAsk(all_fields[1]);
                        ((PublicExecuteAsk)execute).add(Arrays.copyOfRange(all_fields, 2, all_fields.length));
                        break;
                    }
                    execute = new PublicExecuteEnd(all_fields[0]);
                    break;
                }
                case "END": {
                    execute = new PublicExecuteEnd(all_fields[1]);
                    break;
                }
                case "INA": {
                    DDeviceInfo_INA ina = (DDeviceInfo_INA)new DDeviceInfo_INA().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INA", ina);
                    break;
                }
                case "INM": {
                    DDeviceInfo_INM inm = (DDeviceInfo_INM)new DDeviceInfo_INM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INM", inm);
                    break;
                }
                case "INF": {
                    DDeviceInfo_INF inf = (DDeviceInfo_INF)new DDeviceInfo_INF().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INM", inf);
                    break;
                }
                case "INI": {
                    DDeviceInfo_INI ini = (DDeviceInfo_INI)new DDeviceInfo_INI().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("INI", ini);
                    break;
                }
                case "TIM": {
                    DTIM tim = (DTIM)new DTIM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify("TIM", tim);
                    break;
                }
                default: {
                    DataJSONModel jsonModel = DDataUtils.typeToModel(all_fields[0]);
                    if (jsonModel == null) break;
                    execute = dataExecute != null && dataExecute.getSpDWL(all_fields[0]) != null ? new PublicExecuteModifyCache(all_fields[0], new String[][]{all_fields}) : new PublicExecuteModifyCache(all_fields[0], new String[][]{Arrays.copyOfRange(all_fields, 1, all_fields.length)});
                }
            }
        }
        if (execute != null) {
            execute.setSerial(serial);
        }
        return execute;
    }

    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify(PublicExecuteModifyCache modifyCache) {
        return DDataUtils.Public_UnPackage_ModifyCache_To_Modify(modifyCache, false);
    }

    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify(PublicExecuteModifyCache modifyCache, boolean log) {
        Class clazz;
        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setExecute(modifyCache.getExecute());
        modify.setType(modifyCache.getType());
        modify.setSerial(modifyCache.getSerial());
        if (modifyCache.size() > 0 && (clazz = DDataUtils.typeToClazz(modifyCache.getType())) != null) {
            List<Field> fields = null;
            long start = System.currentTimeMillis();
            for (int i = 0; i < modifyCache.getLines().size(); ++i) {
                String[] all_fields = modifyCache.getLines().get(i);
                if (all_fields == null || all_fields.length <= 0) continue;
                DataJSONModel jsonModel = null;
                try {
                    jsonModel = (DataJSONModel)clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                if (jsonModel == null) continue;
                long line_start = System.currentTimeMillis();
                jsonModel.Public_UnPackage(all_fields, fields);
                long line_end = System.currentTimeMillis();
                if (log) {
                    System.out.println(String.format("ModifyCache_To_Modify Line Length: [%s] Time: [%s]", all_fields.length, line_end - line_start));
                }
                modify.add(jsonModel);
            }
            long end = System.currentTimeMillis();
            if (log) {
                System.out.println(String.format("ModifyCache_To_Modify Size: [%s] Time: [%s]", modifyCache.size(), end - start));
            }
        }
        return modify;
    }

    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify_No_Reflex(PublicExecuteModifyCache modifyCache) {
        return DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex(modifyCache, false);
    }

    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify_No_Reflex(PublicExecuteModifyCache modifyCache, boolean log) {
        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setExecute(modifyCache.getExecute());
        modify.setType(modifyCache.getType());
        modify.setSerial(modifyCache.getSerial());
        if (modifyCache.size() > 0) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < modifyCache.getLines().size(); ++i) {
                String[] all_fields;
                DataJSONModel jsonModel = DDataUtils.typeToModel(modifyCache.getType());
                if (jsonModel == null || (all_fields = modifyCache.getLines().get(i)) == null || all_fields.length <= 0) continue;
                long line_start = System.currentTimeMillis();
                jsonModel.Public_UnPackage_No_Reflex(all_fields);
                long line_end = System.currentTimeMillis();
                if (log) {
                    System.out.println(String.format("ModifyCache_To_Modify Line Length: [%s] Time: [%s]", all_fields.length, line_end - line_start));
                }
                modify.add(jsonModel);
            }
            long end = System.currentTimeMillis();
            if (log) {
                System.out.println(String.format("ModifyCache_To_Modify Size: [%s] Time: [%s]", modifyCache.size(), end - start));
            }
        }
        return modify;
    }

    private static DataJSONModel typeToModel(String type) {
        DataJSONModel model = null;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "TMS": {
                    model = new DDataParameterV1();
                    break;
                }
                case "TMT": {
                    model = new DTextParameterV1();
                    break;
                }
                case "CLS": {
                    model = new DCategoryV1();
                    break;
                }
                case "PLU": {
                    model = new DPLUV5();
                    break;
                }
                case "BAR": {
                    model = new DBarcodeFormatV1();
                    break;
                }
                case "LAT": {
                    model = new DLabelFormatV1();
                    break;
                }
                case "SAJ": {
                    model = new DSaleJobV1();
                    break;
                }
                case "SAL": {
                    model = new DSaleManV1();
                    break;
                }
                case "SCP": {
                    model = new DShortKeyV1();
                    break;
                }
                case "SCG": {
                    model = new DShortPageV1();
                    break;
                }
                case "SGF": {
                    model = new DShortPageFormworkV1();
                    break;
                }
                case "AIF": {
                    model = new DAIFeatureV1();
                    break;
                }
                case "BMP": {
                    model = new DBitMapV1();
                    break;
                }
                case "FNT": {
                    model = new DFontV1();
                    break;
                }
                case "REP": {
                    model = new DLOGV1();
                    break;
                }
                default: {
                    Integer spDWL;
                    if (dataExecute == null || (spDWL = dataExecute.getSpDWL(type)) == null) break;
                    model = new DSpDWLV1();
                }
            }
        }
        return model;
    }

    private static Class typeToClazz(String type) {
        Class clazz = null;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "TMS": {
                    clazz = DDataParameterV1.class;
                    break;
                }
                case "TMT": {
                    clazz = DTextParameterV1.class;
                    break;
                }
                case "CLS": {
                    clazz = DCategoryV1.class;
                    break;
                }
                case "PLU": {
                    clazz = DPLUV5.class;
                    break;
                }
                case "BAR": {
                    clazz = DBarcodeFormatV1.class;
                    break;
                }
                case "LAT": {
                    clazz = DLabelFormatV1.class;
                    break;
                }
                case "SAJ": {
                    clazz = DSaleJobV1.class;
                    break;
                }
                case "SAL": {
                    clazz = DSaleManV1.class;
                    break;
                }
                case "SCP": {
                    clazz = DShortKeyV1.class;
                    break;
                }
                case "SCG": {
                    clazz = DShortPageV1.class;
                    break;
                }
                case "AIF": {
                    clazz = DAIFeatureV1.class;
                    break;
                }
                case "SGF": {
                    clazz = DShortPageFormworkV1.class;
                    break;
                }
                case "BMP": {
                    clazz = DBitMapV1.class;
                    break;
                }
                case "FNT": {
                    clazz = DFontV1.class;
                    break;
                }
                case "REP": {
                    clazz = DLOGV1.class;
                }
            }
        }
        return clazz;
    }

    public static List<Field> Public_Fields(Class<? extends DataJSONModel> clazz) {
        List<Field> fields = DataJSONModelFieldMap.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        try {
            DataClass class_annotation = clazz.getAnnotation(DataClass.class);
            if (class_annotation != null) {
                ArrayList ignorePublicFields = StringUtils.isNotBlank((CharSequence)class_annotation.ignorePublicField()) ? Arrays.asList(class_annotation.ignorePublicField().split(",")) : new ArrayList();
                DataJSONModel dataJSONModel = clazz.newInstance();
                Map<String, Field> fieldMap = dataJSONModel.allAndroidField();
                for (Field field : fieldMap.values()) {
                    PublicField annotation;
                    if (ignorePublicFields.contains(field.getName()) || (annotation = field.getAnnotation(PublicField.class)) == null) continue;
                    fields.add(field);
                }
                Collections.sort(fields, new Comparator<Field>(){

                    @Override
                    public int compare(Field o1, Field o2) {
                        PublicField oa1 = o1.getAnnotation(PublicField.class);
                        PublicField oa2 = o2.getAnnotation(PublicField.class);
                        return oa1.index() - oa2.index();
                    }
                });
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        DataJSONModelFieldMap.put(clazz, fields);
        return fields;
    }

    public static long disPowersToDisPower(List<Integer> disPowers) {
        if (disPowers == null || disPowers.isEmpty()) {
            return 0L;
        }
        String binary = "";
        for (int i = 1; i <= DConstant.BAR_SCALE_AUTH_LENGTH; ++i) {
            binary = (disPowers.contains(i) ? (char)'1' : '0') + binary;
        }
        return Long.parseLong(binary, 2);
    }

    public static List<Integer> disPowerToDisPowers(long disPower) {
        String binary = Long.toBinaryString(disPower);
        ArrayList<Integer> disPowers = new ArrayList<Integer>();
        int dp = 1;
        for (int i = binary.length() - 1; i >= 0; --i) {
            if (binary.charAt(i) == '1') {
                disPowers.add(dp);
            }
            ++dp;
        }
        return disPowers;
    }

    public static List<Integer> disPowerToDisPowers(String disPowerStr) {
        long disPower = 0L;
        try {
            disPower = Long.parseLong(disPowerStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DDataUtils.disPowerToDisPowers(disPower);
    }

    public static String version(String config_v, String board_v, String app_v) {
        board_v = StringUtils.isNotBlank((CharSequence)board_v) ? board_v : "YSB0";
        board_v = board_v.replace("YS", "P").replace("ys", "P");
        config_v = StringUtils.isNotBlank((CharSequence)config_v) ? config_v : "DL000";
        app_v = StringUtils.isNotBlank((CharSequence)app_v) ? app_v : "V3.0.0";
        return String.format("%s %s %s", board_v, config_v, app_v);
    }

    public static String version(String config_v, String board_v, String app_v, String ai_v) {
        return StringUtils.isNotBlank((CharSequence)ai_v) ? String.format("%s %s", DDataUtils.version(config_v, board_v, app_v), ai_v) : DDataUtils.version(config_v, board_v, app_v);
    }
}

