/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateConvertUtil {
    public static final String Detail_Format = "yyyy-MM-dd HH:mm:ss";

    public static TimeZone getBeijingTimeZone() {
        return TimeZone.getTimeZone("GMT+8:00");
    }

    public static TimeZone getPhoneTimeZone() {
        return TimeZone.getDefault();
    }

    public static String getCurrentTimeZoneStr() {
        TimeZone tz = TimeZone.getDefault();
        return DateConvertUtil.createGmtOffsetString(true, true, tz.getRawOffset());
    }

    public static String createGmtOffsetString(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        DateConvertUtil.appendNumber(builder, 2, offsetMinutes / 60);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        DateConvertUtil.appendNumber(builder, 2, offsetMinutes % 60);
        return builder.toString();
    }

    private static void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public static Date parseToDate(String date, String format) {
        Date dt = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            dt = dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dt;
    }

    public static String formatDateToStr(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date changeTimeZone(Date date, TimeZone oldZone, TimeZone newZone) {
        Date dateTmp = null;
        if (date != null) {
            int timeOffset = oldZone.getRawOffset() - newZone.getRawOffset();
            dateTmp = new Date(date.getTime() - (long)timeOffset);
        }
        return dateTmp;
    }

    public static String beijingTime2PhoneTime(String beijingTime, String format) {
        Date beijingDate = DateConvertUtil.parseToDate(beijingTime, format);
        Date phoneDate = DateConvertUtil.changeTimeZone(beijingDate, DateConvertUtil.getBeijingTimeZone(), DateConvertUtil.getPhoneTimeZone());
        String phoneTime = DateConvertUtil.formatDateToStr(phoneDate, format);
        return phoneTime;
    }

    public static String phoneTime2BeijingTime(String phoneTime) {
        Date phoneDate = DateConvertUtil.parseToDate(phoneTime, Detail_Format);
        Date beijingDate = DateConvertUtil.changeTimeZone(phoneDate, DateConvertUtil.getPhoneTimeZone(), DateConvertUtil.getBeijingTimeZone());
        String beijingTime = DateConvertUtil.formatDateToStr(beijingDate, Detail_Format);
        return beijingTime;
    }
}

