/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.em.ServerExp;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.ByteUtils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final Long TIME_2000_1_1_0_0_0 = 946656000000L;
    public static final String YYYY_MM_DD_HH_MM_SS_Space = "yyyy MM dd HH mm ss";
    public static final String YY_MM_DD_HH_MM_SS_Space = "yy MM dd HH mm ss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_S = "yyyy-MM-dd HH:mm:ss.S";
    public static final String YYYY_MM_DD_HH_MM_SS_C = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYMMDD = "yyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSS = "yyyyMMddHHmmssS";
    public static final String HHMMSS = "HHmmss";
    public static final String HHMMSSS = "HHmmssS";
    public static final String HHMMSSSSS = "HHmmssSSS";
    public static final String YYYY = "yyyy";
    public static final String C_YYYY = "yyyy\u5e74";
    public static final String YYYYMM = "yyyyMM";
    public static final String YEAR_MONTH_FORMAT = "yyyy-MM";
    public static final String C_YYYYMM = "yyyy\u5e74MM\u6708";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String C_YYYYMMDD = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String LOCATE_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String YYYYMMDD_HH_MM_SS = "yyyyMMdd HH:mm:ss";
    public static final String YYYYMMDD_T_HH_MM_SS = "yyyyMMddTHH:mm:ss";
    private static final int DAYS_OF_A_WEEK = 7;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private DateUtils() {
    }

    public static String getTime() throws TechnologyException {
        Date date = DateUtils.getDefaultTime();
        int seconds = (int)((new Date().getTime() - date.getTime()) / 1000L);
        String time = Integer.toHexString(seconds);
        for (int i = 0; i < 8 - time.length(); ++i) {
            time = "0" + time;
        }
        return ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexAscii(time)));
    }

    public static Date getDefaultTime() {
        try {
            return DateUtils.getDateTime("2000-01-01 00:00:00", YYYY_MM_DD_HH_MM_SS);
        }
        catch (TechnologyException e) {
            return new Date(946656000000L);
        }
    }

    public static synchronized Date timeStrFormat(String strDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            return sdf.parse(strDate);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String timeFormat(Date date) {
        try {
            return DateUtils.getString(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String getFormatDate_YYYY_MM_DD_HH_MM_SS_Space(Date date) {
        return DateUtils.getFormatDate(date, YYYY_MM_DD_HH_MM_SS_Space);
    }

    public static synchronized String getFormatDate_YY_MM_DD_HH_MM_SS_Space(Date date) {
        return DateUtils.getFormatDate(date, YY_MM_DD_HH_MM_SS_Space);
    }

    public static synchronized Date getDateTime_YYYY_MM_DD_HH_MM_SS_Space(String dateStr) {
        try {
            return DateUtils.getDateTime(dateStr, YYYY_MM_DD_HH_MM_SS_Space);
        }
        catch (TechnologyException e) {
            return null;
        }
    }

    public static synchronized Date getDateTime_YY_MM_DD_HH_MM_SS_Space(String dateStr) {
        try {
            return DateUtils.getDateTime(dateStr, YY_MM_DD_HH_MM_SS_Space);
        }
        catch (TechnologyException e) {
            return null;
        }
    }

    public static synchronized Date timeStrFormat1(String strDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_S);
            return sdf.parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized String getCString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_C);
        return sdf.format(date);
    }

    public static synchronized String getString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return sdf.format(date);
    }

    public static synchronized Date getFormtDateTime(String dateStr, String format) throws TechnologyException {
        return DateUtils.getDateTime(dateStr, format);
    }

    public static Date formatDateTime(Date date, String format) throws TechnologyException {
        return DateUtils.formatDate(date, format);
    }

    public static synchronized String getDate_YYYY_MM_DD_HH_MM_SS(Date date) {
        return DateUtils.getFormatDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static synchronized String getDate_YYYYMMDD(Date date) {
        return DateUtils.getFormatDate(date, YYYYMMDD);
    }

    public static synchronized String getDate_YYMMDD(Date date) {
        return DateUtils.getFormatDate(date, YYMMDD);
    }

    public static synchronized Date getDate__YYMMDD(String dateStr) {
        return DateUtils.getFormatDate(dateStr, YYMMDD);
    }

    public static synchronized String getDate_YYYYMM(Date date) {
        return DateUtils.getFormatDate(date, YYYYMM);
    }

    public static synchronized String getDate_YYYYMMDDHH(Date date) {
        return DateUtils.getFormatDate(date, YYYYMMDDHH);
    }

    public static synchronized Date getDate_YYYYMMDDHH_start(String yyyymmddhh) {
        try {
            return DateUtils.getDateTime(yyyymmddhh + "0000", "yyyyMMddHHmmss");
        }
        catch (TechnologyException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static synchronized Date getDate_yyyyMMdd_start(String yyyyMMdd) {
        try {
            return DateUtils.getDateTime(yyyyMMdd + "000000", "yyyyMMddHHmmss");
        }
        catch (TechnologyException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static synchronized Date getDate_YYYYMMDDHH_end(String yyyymmddhh) {
        try {
            return DateUtils.getDateTime(yyyymmddhh + "5959", "yyyyMMddHHmmss");
        }
        catch (TechnologyException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static synchronized Date getDate_yyyyMMdd_end(String yyyyMMdd) {
        try {
            return DateUtils.getDateTime(yyyyMMdd + "235959", "yyyyMMddHHmmss");
        }
        catch (TechnologyException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static synchronized String getDate_YYYY_MM_DD_HH_MM_SS(Date date, String timeZone) {
        return DateUtils.getFormatDate(DateUtils.sysTimeToTimeZone(date, timeZone), YYYY_MM_DD_HH_MM_SS);
    }

    public static synchronized String getDate_YYYYMMDD(Date date, String timeZone) {
        return DateUtils.getFormatDate(DateUtils.sysTimeToTimeZone(date, timeZone), YYYYMMDD);
    }

    public static synchronized String getDate_YYYYMM(Date date, String timeZone) {
        return DateUtils.getFormatDate(DateUtils.sysTimeToTimeZone(date, timeZone), YYYYMM);
    }

    public static Date getDefaultDateTime(String dateStr, String timeZone) throws TechnologyException {
        return DateUtils.sysTimeToTimeZone(DateUtils.getDateTime(dateStr, YYYY_MM_DD_HH_MM_SS), timeZone);
    }

    public static Date getDefaultDateTime(String dateStr) throws TechnologyException {
        return DateUtils.sysTimeToTimeZone(DateUtils.getDateTime(dateStr, YYYY_MM_DD_HH_MM_SS), null);
    }

    public static synchronized Date getDateTime(String dateStr, String format) throws TechnologyException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr);
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, ServerExp.\u65f6\u95f4\u89e3\u6790\u5f02\u5e38);
        }
    }

    public static String getTimeZoneStr(String timeZone) {
        return DateUtils.getFormatDate(new Date(DateUtils.getLongTime(timeZone)), YYYYMMDD);
    }

    public static String getTimeZoneStr(Date date, String timeZone) {
        return DateUtils.getFormatDate(new Date(DateUtils.getLongTime(date, timeZone)), YYYY_MM_DD_HH_MM_SS);
    }

    public static String getTimeZoneStr(Date date) {
        return DateUtils.getTimeZoneStr(date, null);
    }

    public static synchronized String getFormatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static synchronized String getRFC3339FormatDate(Date date) {
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.of("Asia/Shanghai"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        return zonedDateTime.format(formatter);
    }

    public static synchronized Date getFormatDate(String dateStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public static long getLongTime(String timeZone) {
        return DateUtils.getLongTime(new Date(), timeZone);
    }

    public static long getLongTime(Date date, String timeZone) {
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            timeZone = "8";
        }
        return (long)((double)date.getTime() + (Double.parseDouble(timeZone) - 8.0) * 3600000.0);
    }

    public static Date sysTimeToTimeZone(Date date, String timeZone) {
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            timeZone = "8";
        }
        return new Date((long)((double)date.getTime() + (Double.parseDouble(timeZone) - 8.0) * 3600000.0));
    }

    public static Date timeZoneToSysTime(Date date, String timeZone) {
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            timeZone = "8";
        }
        return new Date((long)((double)date.getTime() + (8.0 - Double.parseDouble(timeZone)) * 3600000.0));
    }

    public static Date formatDate(Date date, String format) throws TechnologyException {
        return DateUtils.getDateTime(DateUtils.getFormatDate(date, format), format);
    }

    public static String getNowYearVal() {
        return DateUtils.getFormatDate(DateUtils.getLastDayOfYear(new Date()), YYYY);
    }

    public static String getNowYearVal(Date date) {
        return DateUtils.getFormatDate(DateUtils.getLastDayOfYear(date), YYYY);
    }

    public static String getCNowYearVal() {
        return DateUtils.getFormatDate(DateUtils.getCurrertDate(new Date()), C_YYYY);
    }

    public static String getNowMonthVal() {
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(new Date()), YYYYMM);
    }

    public static String getNowMonthVal(Date date) {
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(date), YYYYMM);
    }

    public static String getCNowMonthVal() {
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(new Date()), C_YYYYMM);
    }

    public static String getNowWeekVal() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(new Date()), YYYY) + "-W" + calendar.get(3);
    }

    public static String getNowWeekVal(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(date), YYYY) + "-W" + calendar.get(3);
    }

    public static String getCNowWeekVal() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return DateUtils.getFormatDate(DateUtils.getLastDayOfMonth(new Date()), C_YYYY) + "-\u7b2c[" + calendar.get(3) + "]\u5468";
    }

    public static String getNowDayVal() {
        return DateUtils.getFormatDate(DateUtils.getCurrertDate(new Date()), YYYYMMDD);
    }

    public static String getNowDayVal(Date date) {
        return DateUtils.getFormatDate(DateUtils.getCurrertDate(date), YYYYMMDD);
    }

    public static String getCNowDayVal() {
        return DateUtils.getFormatDate(DateUtils.getCurrertDate(new Date()), C_YYYYMMDD);
    }

    public static Integer getDateMinutes(Date date1, Date date2) {
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long diff = 0L;
        diff = time1 < time2 ? time2 - time1 : time1 - time2;
        return (int)(diff / 60000L);
    }

    public static int getDateNum(Date fromDate, Date endDate) {
        long days = (endDate.getTime() - fromDate.getTime()) / 86400000L;
        return (int)days;
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date firstDayOfYear = calendar.getTime();
        return firstDayOfYear;
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date firstDayOfMonth = calendar.getTime();
        return firstDayOfMonth;
    }

    public static Date getFirstDayOfMonth(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        Date date = DateUtils.strToDateNotDD(dateStr);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getLastDayOfMonth(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        Date date = DateUtils.strToDateNotDD(dateStr);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    private static Date strToDateNotDD(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMM);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        Date lastDayOfMonth = calendar.getTime();
        return lastDayOfMonth;
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (c.get(7) == 1) {
            c.add(5, -1);
        }
        c.add(5, c.getFirstDayOfWeek() - c.get(7) + 1);
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        Date currertDate = DateUtils.getCurrertDate(date);
        int dayOfWeek = DateUtils.getDayOfWeek(currertDate);
        if (dayOfWeek == 0) {
            return currertDate;
        }
        return DateUtils.addDate(currertDate, 7 - dayOfWeek);
    }

    public static Date getCurrertDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static String getMinMonthDate(String date) {
        try {
            return dateFormat.format(DateUtils.getMinMonthDate(dateFormat.parse(date)));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getMaxMonthDate(String date) {
        try {
            return dateFormat.format(DateUtils.getMaxMonthDate(dateFormat.parse(date)));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.setMinimalDaysInFirstWeek(7);
        return calendar.get(7) - 1;
    }

    public static Date addTime(Date date, int type, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.add(type, num);
        return calendar.getTime();
    }

    public static Date addMilliSecond(Date date, int num) {
        return DateUtils.addTime(date, 14, num);
    }

    public static Date addSecond(Date date, int num) {
        return DateUtils.addTime(date, 13, num);
    }

    public static Date addMin(Date date, int num) {
        return DateUtils.addTime(date, 12, num);
    }

    public static Date addHour(Date date, int num) {
        return DateUtils.addTime(date, 10, num);
    }

    public static Date addHalfDay(Date date, int num) {
        return DateUtils.addTime(date, 9, num);
    }

    public static Date addDate(Date date, int num) {
        return DateUtils.addTime(date, 5, num);
    }

    public static Date addWeek(Date date, int num) {
        return DateUtils.addTime(date, 4, num);
    }

    public static Date addMonth(Date date, int num) {
        return DateUtils.addTime(date, 2, num);
    }

    public static Date addYear(Date date, int num) {
        return DateUtils.addTime(date, 1, num);
    }

    public static Date getLastMonth(Date date) {
        return DateUtils.addMonth(date, -1);
    }

    public static String getCurrentDateTime() {
        return DateUtils.getFormatDate(new Date(), "yyyyMMddHHmmss");
    }

    public static String getDateTime(long time) {
        return DateUtils.getFormatDate(new Date(time), "yyyyMMddHHmmss");
    }

    public static String getWxOrderCloseTime(Date data, int second) {
        long time = data.getTime() + (long)second;
        return DateUtils.getDateTime(time);
    }

    public static String getWxOrderStartTime(Date date) {
        return DateUtils.getDateTime(date.getTime());
    }

    public static String getAliOrderCloseTime(int second) {
        int min = second / 60000;
        return min + "m";
    }

    public static Date getDateOfYesterday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static String getYearyMounthDay(Date date) {
        return DateUtils.getFormatDate(date, YYYY_MM_DD);
    }

    public static Date getDayLastTime(Date date) throws TechnologyException {
        return DateUtils.getDateTime(DateUtils.getYearyMounthDay(date) + " 23:59:59", YYYY_MM_DD_HH_MM_SS);
    }

    public static String getTomorrowVal() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
        calendar.add(6, 1);
        Date date = calendar.getTime();
        return sdf.format(date);
    }

    public static List<String> getMonthBetweenDateStr(String minDate, String maxDate) throws TechnologyException {
        ArrayList<String> listDate = new ArrayList<String>();
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat(YYYYMMDD);
            Date startDate = df.parse(minDate);
            startCalendar.setTime(startDate);
            Date endDate = df.parse(maxDate);
            endCalendar.setTime(endDate);
            while (true) {
                startCalendar.add(5, 1);
                if (startCalendar.getTimeInMillis() < endCalendar.getTimeInMillis()) {
                    listDate.add(df.format(startCalendar.getTime()));
                    continue;
                }
                break;
            }
        }
        catch (ParseException e) {
            throw new TechnologyException((Throwable)e, ServerExp.\u65f6\u95f4\u89e3\u6790\u5f02\u5e38);
        }
        return listDate;
    }

    public static List<Date> getMonthBetweenDate(Date beginDate, Date endDate) {
        if (beginDate.getTime() == endDate.getTime()) {
            return null;
        }
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(beginDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(cal.getTime());
        }
        lDate.add(endDate);
        return lDate;
    }

    public static List<Date> getMonthDay(String dateStr) throws GeneralException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            throw new ProfessionalException("\u65f6\u95f4\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startTime = DateUtils.getDateTime(dateStr, YYYYMM);
        Date endTime = DateUtils.getLastDayOfMonth(startTime);
        return DateUtils.getMonthBetweenDate(startTime, endTime);
    }

    public static List<String> getMonthDayStr(String dateStr) throws GeneralException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            throw new ProfessionalException("\u65f6\u95f4\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date dateTime = DateUtils.getDateTime(dateStr, YYYYMM);
        return DateUtils.getMonthBetweenDateStr(DateUtils.getFormatDate(DateUtils.addDate(dateTime, -1), YYYYMMDD), DateUtils.getFormatDate(DateUtils.addDate(DateUtils.getLastDayOfMonth(dateTime), 1), YYYYMMDD));
    }

    public static Date getDayEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) throws GeneralException {
        try {
            int mi = Integer.parseInt(minDate);
            int mx = Integer.parseInt(maxDate);
            if (mi > mx) {
                throw new ProfessionalException(ServerExp.\u65f6\u95f4\u89e3\u6790\u5f02\u5e38);
            }
        }
        catch (NumberFormatException e) {
            throw new TechnologyException((Throwable)e, ServerExp.\u65f6\u95f4\u89e3\u6790\u5f02\u5e38);
        }
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMM);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
        }
        catch (ParseException e) {
            throw new TechnologyException((Throwable)e, ServerExp.\u65f6\u95f4\u89e3\u6790\u5f02\u5e38);
        }
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static String getPassMonthDate(int flag, String format, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(2, flag);
        Date dateFrom = cl.getTime();
        return sdf.format(dateFrom);
    }

    public static String getPassMonthNowDate(int flag, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar cl = Calendar.getInstance();
        cl.add(2, flag);
        Date dateFrom = cl.getTime();
        return sdf.format(dateFrom);
    }

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

