/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.em.Platform;
import com.jhscale.common.em.ServerExp;
import com.jhscale.common.em.SyncDataType;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.file.ImageSimilar;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.PictureUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public class FileUtils {
    private static final int BUFFER_SIZE = 2048;

    private FileUtils() {
    }

    public static String getFileName(String url) {
        return url.substring(url.lastIndexOf(47) + 1);
    }

    public static byte[] getFileBytes(File file) throws TechnologyException {
        try {
            return FileUtils.inputStreamToBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new TechnologyException((Throwable)e, ServerExp.\u6587\u4ef6\u672a\u53d1\u73b0);
        }
    }

    public static void getInputStream(String url, FileInputStreamExecute execute) throws TechnologyException {
        InputStream inputStream = null;
        try {
            URLConnection conn = new URL(url).openConnection();
            inputStream = conn.getInputStream();
            if (Objects.nonNull(execute)) {
                execute.inputStream(inputStream);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new TechnologyException((Throwable)e, ServerExp.URL\u8bc6\u522b\u5f02\u5e38);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStreamToBytes(InputStream inputStream) {
        byte[] bytes = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int len = 0;
            while (-1 != (len = inputStream.read(buffer))) {
                baos.write(buffer, 0, len);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    public static byte[] getBytes(String url) throws TechnologyException {
        FileInputStreamExecute execute = new FileInputStreamExecute(){
            byte[] bytes = null;

            @Override
            public void inputStream(InputStream inputStream) throws TechnologyException {
                this.bytes = FileUtils.inputStreamToBytes(inputStream);
            }

            @Override
            public Object result() {
                return this.bytes;
            }
        };
        FileUtils.getInputStream(url, execute);
        return (byte[])execute.result();
    }

    public static void getFile(String url, File file) throws TechnologyException {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        byte[] bytes = FileUtils.getBytes(url);
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (FileNotFoundException e) {
            throw new TechnologyException((Throwable)e, ServerExp.\u6587\u4ef6\u672a\u53d1\u73b0);
        }
        catch (IOException e) {
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getFile(String url, String filePath, String fileName) throws TechnologyException {
        try {
            File file;
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            if (!(file = new File(pathFile, fileName)).exists()) {
                file.createNewFile();
            }
            FileUtils.getFile(url, file);
            return file;
        }
        catch (IOException e) {
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
    }

    public static File getFileByFullPath(String url, String fullPath) throws TechnologyException {
        try {
            File file = new File(fullPath);
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            FileUtils.getFile(url, file);
            return file;
        }
        catch (IOException e) {
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
    }

    public static File getFileByParentPath(String url, String parentPath) throws TechnologyException {
        try {
            File parentFile = new File(parentPath);
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            File file = new File(parentFile, FileUtils.getFileName(url));
            file.createNewFile();
            FileUtils.getFile(url, file);
            return file;
        }
        catch (IOException e) {
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
    }

    public static boolean writer(String content, File file) {
        return FileUtils.writer(content, file, false);
    }

    public static boolean writer(String content, File file, boolean append) {
        return FileUtils.writer(content.getBytes(), file, append);
    }

    public static boolean writer(byte[] bytes, File file) {
        return FileUtils.writer(bytes, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writer(byte[] bytes, File file, boolean append) {
        if (file != null) {
            FileOutputStream fos = null;
            try {
                if (!file.exists()) {
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    file.createNewFile();
                }
                fos = new FileOutputStream(file, append);
                fos.write(bytes, 0, bytes.length);
                boolean parentFile = true;
                return parentFile;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            while (br.ready()) {
                buffer = buffer.append(br.readLine());
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader(InputStream inputStream) {
        InputStreamReader reader = null;
        BufferedReader br = null;
        StringBuilder buffer = new StringBuilder();
        try {
            reader = new InputStreamReader(inputStream, "GBK");
            br = new BufferedReader(reader);
            String line = "";
            while ((line = br.readLine()) != null) {
                buffer.append(line).append("\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(String content, OutputStream stream) {
        try {
            byte[] bytes = content.getBytes("GBK");
            stream.write(bytes, 0, bytes.length);
            stream.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readerLine(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            while (br.ready()) {
                buffer = buffer.append(br.readLine() + "\r\n");
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static int[][][] getPX(String path) {
        File file = new File(path);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        int minx = bi.getMinX();
        int miny = bi.getMinY();
        int[][][] list = new int[width][height][3];
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int[] rgb = new int[3];
                int pixel = bi.getRGB(i, j);
                rgb[0] = (pixel & 0xFF0000) >> 16;
                rgb[1] = (pixel & 0xFF00) >> 8;
                rgb[2] = pixel & 0xFF;
                list[i][j] = rgb;
            }
        }
        return list;
    }

    public static ImageSimilar compareImage(String imgPath1, String imgPath2) {
        String[] images = new String[]{imgPath1, imgPath2};
        if (images.length == 0) {
            System.out.println("Usage >java BMPLoader ImageFile.bmp");
            System.exit(0);
        }
        int[][][] list1 = FileUtils.getPX(images[0]);
        int[][][] list2 = FileUtils.getPX(images[1]);
        int xiangsi = 0;
        int busi = 0;
        int i = 0;
        int j = 0;
        for (int[][] strings : list1) {
            if (i + 1 == list1.length) continue;
            for (int m = 0; m < strings.length; ++m) {
                try {
                    int[] value1 = list1[i][j];
                    int[] value2 = list2[i][j];
                    int k = 0;
                    for (int n = 0; n < value2.length; ++n) {
                        if (Math.abs(value1[k] - value2[k]) < 5) {
                            ++xiangsi;
                            continue;
                        }
                        ++busi;
                    }
                }
                catch (RuntimeException e) {
                    continue;
                }
                ++j;
            }
            ++i;
        }
        BigDecimal bxiangsi = new BigDecimal(xiangsi);
        BigDecimal bbusi = new BigDecimal(busi);
        BigDecimal baifen = bxiangsi.divide(bxiangsi.add(bbusi), 4, 4);
        return new ImageSimilar(xiangsi, busi, baifen);
    }

    public static String terminal_data_file_name(Platform platform) {
        return FileUtils.terminal_data_file_name(platform.getSign());
    }

    public static String terminal_data_file_name(String sign) {
        return sign + DateUtils.getFormatDate(new Date(), "HHmmssSSS") + ".TMS";
    }

    public static String server_data_file_name(String type) {
        return Platform.S.getSign() + type + ".TMS";
    }

    public static String server_data_file_name(SyncDataType type) {
        return FileUtils.server_data_file_name(type.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File source, File target) {
        block27: {
            boolean bl;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int len;
                if (source == null || !source.exists() || target == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                File parentFile = target.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);
                outputStream = Files.newOutputStream(target.toPath(), new OpenOption[0]);
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, len);
                }
                bl = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block27;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public static boolean copyFolder(File source, File target) {
        try {
            if (source.isDirectory()) {
                String[] files;
                if (!target.exists()) {
                    target.mkdir();
                }
                for (String file : files = source.list()) {
                    File srcFile = new File(source, file);
                    File destFile = new File(target, file);
                    FileUtils.copyFolder(srcFile, destFile);
                }
                return true;
            }
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean remove(File source, File target) {
        boolean result = FileUtils.copy(source, target);
        if (result) {
            source.delete();
        }
        return result;
    }

    public static boolean delete(File file) {
        if (file != null && file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    FileUtils.delete(f);
                }
            }
            return file.delete();
        }
        return false;
    }

    public static void cropImage(String source, String target, String suffix, int x, int y, int w, int h) {
        FileUtils.cropImage(new File(source), new File(target), suffix, x, y, w, h);
    }

    public static void cropImage(File source, File target, String suffix, int x, int y, int w, int h) {
        try {
            BufferedImage bufferedimage = ImageIO.read(source);
            BufferedImage newBufferedImage = new BufferedImage(bufferedimage.getWidth(), bufferedimage.getHeight(), 1);
            newBufferedImage.createGraphics().drawImage(bufferedimage, 0, 0, Color.WHITE, null);
            bufferedimage = newBufferedImage;
            BufferedImage cut1 = PictureUtils.cut(bufferedimage, x, y, w, h);
            PictureUtils.write(cut1, suffix, target);
            System.out.printf("\u88c1\u526a\u56fe\u7247 %s  \u6e90\u5730\u5740\uff1a%s   \u76ee\u6807\u5730\u5740\uff1a%s", source.exists(), source.getAbsoluteFile(), target.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.printf("\u88c1\u526a\u56fe\u7247 \u6e90\u5730\u5740\uff1a%s   \u76ee\u6807\u5730\u5740\uff1a%s \u5f02\u5e38\uff1a%s", source.getAbsoluteFile(), target.getAbsolutePath(), e.getMessage());
        }
    }

    public static void zipDirectory(File sourceDir, File zipFile) {
        FileUtils.zipDirectory(sourceDir.getAbsolutePath(), zipFile.getAbsolutePath());
    }

    public static void zipDirectory(String sourceDir, String zipFile) {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            File dir = new File(sourceDir);
            FileUtils.zipDirectory(dir, dir.getName(), zos);
            zos.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void zipDirectory(File dir, String baseName, ZipOutputStream zos) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.zipDirectory(file, baseName + File.separator + file.getName(), zos);
                    continue;
                }
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(baseName + File.separator + file.getName());
                    zos.putNextEntry(zipEntry);
                    byte[] buffer = new byte[2048];
                    while ((length = fis.read(buffer)) >= 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
            }
        }
    }

    public static void unzip(File zipFile, File destDir) {
        FileUtils.unzip(zipFile.getAbsolutePath(), destDir.getAbsolutePath());
    }

    public static void unzip(String zipFile, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File newFile = new File(destDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    new File(newFile.getParent()).mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toZip(String srcDir, OutputStream out, boolean KeepDirStructure) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            File sourceFile = new File(srcDir);
            FileUtils.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure);
            long end = System.currentTimeMillis();
            System.out.printf("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a%s ms%n", end - start);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void toZip(List<File> srcFiles, OutputStream out) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[2048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            long end = System.currentTimeMillis();
            System.out.printf("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a%s ms%n", end - start);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + File.separator));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        FileUtils.compress(file, zos, name + File.separator + file.getName(), KeepDirStructure);
                        continue;
                    }
                    FileUtils.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }

    public static interface FileInputStreamExecute {
        public void inputStream(InputStream var1) throws TechnologyException;

        public Object result();
    }
}

