/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.jhscale.common.utils.JSONUtils;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class GJSONUtils {
    private static Gson gson = null;

    private GJSONUtils() {
    }

    public static void gson_time() {
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAdapter()).create();
    }

    public static boolean isJSON(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                JsonParser.parseString((String)json);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String objectToJSON(Object obj) {
        if (Objects.nonNull(obj)) {
            return gson.toJson(obj);
        }
        return null;
    }

    public static byte[] objectToUTF8Bytes(Object obj) {
        String json = GJSONUtils.objectToJSON(obj);
        return StringUtils.isNotBlank((CharSequence)json) ? json.getBytes(Charset.forName("UTF8")) : null;
    }

    public static String objectToUTF8Base64Code(Object obj) {
        byte[] jsonbytes = GJSONUtils.objectToUTF8Bytes(obj);
        return Objects.nonNull(jsonbytes) ? Base64.encode(jsonbytes) : null;
    }

    public static String UTF8Base64CodeToJSON(String base64) {
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            try {
                return new String(Base64.decode(base64), Charset.forName("UTF8"));
            }
            catch (Base64DecodingException e) {
                System.err.println("\u6570\u636e\uff1a{" + base64 + "} \u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> T UTF8Base64CodeToObject(String base64, Class<T> clazz) {
        String json = GJSONUtils.UTF8Base64CodeToJSON(base64);
        return StringUtils.isNotBlank((CharSequence)json) ? (T)GJSONUtils.jsonToObject(json, clazz) : null;
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (T)gson.fromJson(json, clazz);
            }
            catch (Exception e) {
                System.err.println("\u6570\u636e\uff1a{" + json + "} \u8f6c\u5bf9\u8c61\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> List<T> jsonToList(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                Gson gson = new Gson();
                ArrayList<Object> list = new ArrayList<Object>();
                JsonArray array = new JsonParser().parse(json).getAsJsonArray();
                for (JsonElement elem : array) {
                    list.add(gson.fromJson(elem, clazz));
                }
                return list;
            }
            catch (Exception e) {
                System.err.println("\u6570\u636e\uff1a" + json + " \u8f6c\u96c6\u5408\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> T objectToObject(Object obj, Class<T> clazz) {
        if (Objects.nonNull(obj)) {
            return GJSONUtils.jsonToObject(GJSONUtils.objectToJSON(obj), clazz);
        }
        return null;
    }

    public static <T> List<T> listToList(List list, Class<T> clazz) {
        if (Objects.nonNull(list) && !list.isEmpty()) {
            try {
                return GJSONUtils.jsonToList(GJSONUtils.objectToJSON(list), clazz);
            }
            catch (Exception e) {
                System.err.println("\u96c6\u5408\uff1a" + list + " \u8f6c\u96c6\u5408\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> Map<String, T> gsonToMaps(String json) {
        Map map = null;
        if (gson != null) {
            map = (Map)gson.fromJson(json, new TypeToken<Map<String, T>>(){}.getType());
        }
        return map;
    }

    public static String parseObject(Object obj) {
        return JSONUtils.parseJSON(GJSONUtils.objectToJSON(obj));
    }

    public static String getString(String json, String key, String defval) {
        try {
            JsonElement element = new JsonParser().parse(json);
            if (!element.isJsonNull()) {
                String string = element.getAsJsonObject().get(key).toString();
                return StringUtils.isNotBlank((CharSequence)string) ? string : defval;
            }
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
        }
        return defval;
    }

    public static String getString(String json, String key) {
        return GJSONUtils.getString(json, key, "");
    }

    public static Integer getInt(String json, String key, Integer defval) {
        try {
            JsonElement element = new JsonParser().parse(json);
            if (!element.isJsonNull()) {
                String string = element.getAsJsonObject().get(key).toString();
                return StringUtils.isNotBlank((CharSequence)string) ? Integer.parseInt(string) : defval;
            }
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
        }
        return defval;
    }

    public static Integer getInt(String json, String key) {
        return GJSONUtils.getInt(json, key, 0);
    }

    public static Double getDouble(String json, String key, Double defval) {
        try {
            JsonElement element = new JsonParser().parse(json);
            if (!element.isJsonNull()) {
                String string = element.getAsJsonObject().get(key).toString();
                return StringUtils.isNotBlank((CharSequence)string) ? Double.parseDouble(string) : defval;
            }
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
        }
        return defval;
    }

    public static Double getDouble(String json, String key) {
        return GJSONUtils.getDouble(json, key, 0.0);
    }

    static {
        gson = new Gson();
    }

    public static class DateAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.dateFormat.parse(json.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.dateFormat.format(src));
        }
    }
}

