/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class GZIPUtils {
    private static final String CHARSET = "ISO-8859-1";

    private GZIPUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = null;
        DeflaterOutputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            String string = out.toString(CHARSET);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gunzip = null;
        try {
            int n;
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(str.getBytes(CHARSET));
            gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gunzip != null) {
                try {
                    gunzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip7z(File source, File target) {
        if (source == null || !source.exists()) {
            return target;
        }
        if (target == null) {
            target = new File(source.getAbsolutePath().substring(0, source.getAbsolutePath().lastIndexOf(".7z")));
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        SevenZFile sevenZFile = null;
        try {
            sevenZFile = new SevenZFile(source);
            SevenZArchiveEntry entry = null;
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                OutputStream out = null;
                FilterOutputStream bos = null;
                try {
                    File file = new File(target, entry.getName());
                    if (!file.exists()) {
                        new File(file.getParent()).mkdirs();
                    }
                    out = new FileOutputStream(file);
                    bos = new BufferedOutputStream(out);
                    int len = -1;
                    byte[] buf = new byte[(int)entry.getSize()];
                    while ((len = sevenZFile.read(buf)) != -1) {
                        ((BufferedOutputStream)bos).write(buf, 0, len);
                    }
                    ((BufferedOutputStream)bos).flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (bos == null) continue;
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (sevenZFile != null) {
                try {
                    sevenZFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip7z(File source, File target) {
        if (target == null) {
            target = new File(source.getParent(), source.getName() + ".7z");
        }
        SevenZOutputFile sevenZOutputFile = null;
        try {
            if (!target.exists()) {
                target.createNewFile();
            }
            sevenZOutputFile = new SevenZOutputFile(target);
            for (File file : source.listFiles()) {
                SevenZArchiveEntry entry = sevenZOutputFile.createArchiveEntry(file, file.getName());
                sevenZOutputFile.putArchiveEntry((ArchiveEntry)entry);
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    byte[] b = new byte[1024];
                    int count = 0;
                    while ((count = in.read(b)) > 0) {
                        sevenZOutputFile.write(b, 0, count);
                    }
                }
                sevenZOutputFile.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (sevenZOutputFile != null) {
                try {
                    sevenZOutputFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return target;
    }
}

