/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.em.ServerExp;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private static CloseableHttpClient httpClient;

    public static String get(String url) throws TechnologyException {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            httpGet.setConfig(requestConfig);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            httpGet.setHeader("Accept", "application/json");
            response = httpClient.execute((HttpUriRequest)httpGet);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("HTTP Get Error,exp:{}", (Object)e.getMessage(), (Object)e);
            throw new TechnologyException((Throwable)e, ServerExp.IO\u5f02\u5e38);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> heads) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            httpGet.setConfig(requestConfig);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            if (heads != null && !heads.isEmpty()) {
                heads.forEach((k, v) -> httpGet.addHeader(k, v));
            }
            httpGet.setHeader("Accept", "application/json");
            response = httpClient.execute((HttpUriRequest)httpGet);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("HTTP Get Error,exp:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String jsonString) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(jsonString, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("HTTP Post Error,exp:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String jsonString, Map<String, String> heads) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            if (heads != null && !heads.isEmpty()) {
                heads.forEach((k, v) -> httpPost.addHeader(k, v));
            }
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(jsonString, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("HTTP Post Error,exp:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result.trim();
    }

    public static String upload(String url, File file) throws TechnologyException {
        return HttpUtils.upload(url, FileUtils.getFileBytes(file));
    }

    public static String upload(String url, InputStream inputStream) throws TechnologyException {
        return HttpUtils.upload(url, FileUtils.inputStreamToBytes(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String url, byte[] bytes) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addBinaryBody("media", bytes).setMode(HttpMultipartMode.RFC6532);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(multipartEntityBuilder.build());
            httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
            response = httpClient.execute((HttpUriRequest)httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        }
        catch (IOException e) {
            LOGGER.error("HTTP Post Upload byte[] Error,exp:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result.trim();
    }

    public static void download(String url, File file) {
        HttpUtils.download(url, file, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, File file, String method) {
        File parentFile;
        if (file == null) {
            return;
        }
        if (!file.exists() && !(parentFile = file.getParentFile()).exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOut = null;
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.connect();
            inputStream = conn.getInputStream();
            bis = new BufferedInputStream(inputStream);
            fileOut = new FileOutputStream(file);
            bos = new BufferedOutputStream(fileOut);
            byte[] buf = new byte[4096];
            int length = bis.read(buf);
            while (length != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, length);
                length = bis.read(buf);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("File Download Fail,Url {} Not Found:{}", new Object[]{url, e.getMessage(), e});
        }
        catch (Exception e) {
            LOGGER.error("File Download Fail {},exp:{}", new Object[]{url, e.getMessage(), e});
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        cm.setDefaultMaxPerRoute(50);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

