/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.license.RSAKey;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class JRSAUtil {
    private static final Charset UTF_8 = JHContents.UTF_8;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String ALGORITHMS = "RSA/ECB/PKCS1Padding";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final int INITIALIZE_LENGTH = 1024;

    public static RSAKey genKeyPair() throws TechnologyException {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            return new RSAKey(Base64.encodeBase64String((byte[])publicKey.getEncoded()), Base64.encodeBase64String((byte[])privateKey.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u8bc1\u4e66\u521b\u5efa\u5931\u8d25);
        }
    }

    public static String decryptByPrivateKey(String encryptedData, String privateKey) throws TechnologyException {
        return new String(JRSAUtil.decryptByPrivateKey(Base64.decodeBase64((String)encryptedData), privateKey), UTF_8);
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws TechnologyException {
        try {
            PrivateKey privateK = KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey)));
            Cipher cipher = Cipher.getInstance(ALGORITHMS);
            cipher.init(2, privateK);
            return JRSAUtil.encryptAndDecryptOfSubsection(encryptedData, cipher, 128);
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u8bc1\u4e66\u89e3\u5bc6\u5931\u8d25);
        }
    }

    public static String encryptByPublicKey(String data, String publicKey) throws TechnologyException {
        return Base64.encodeBase64String((byte[])JRSAUtil.encryptByPublicKey(data.getBytes(UTF_8), publicKey));
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws TechnologyException {
        try {
            PublicKey publicK = KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey)));
            Cipher cipher = Cipher.getInstance(ALGORITHMS);
            cipher.init(1, publicK);
            return JRSAUtil.encryptAndDecryptOfSubsection(data, cipher, 117);
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u8bc1\u4e66\u52a0\u5bc6\u5931\u8d25);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] encryptAndDecryptOfSubsection(byte[] data, Cipher cipher, int encryptBlock) throws Exception {
        try (ByteArrayOutputStream out = null;){
            int inputLen = data.length;
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > encryptBlock ? cipher.doFinal(data, offSet, encryptBlock) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * encryptBlock;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String decryptByPublicKey(String encryptedData, String publicKey) throws TechnologyException {
        return new String(JRSAUtil.decryptByPublicKey(Base64.decodeBase64((String)encryptedData), publicKey), UTF_8);
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws TechnologyException {
        return JRSAUtil.decryptByPublicKey(encryptedData, Base64.decodeBase64((String)publicKey));
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, byte[] publicKey) throws TechnologyException {
        try {
            PublicKey publicK = KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(publicKey));
            Cipher cipher = Cipher.getInstance(ALGORITHMS);
            cipher.init(2, publicK);
            return JRSAUtil.encryptAndDecryptOfSubsection(encryptedData, cipher, 128);
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u8bc1\u4e66\u89e3\u5bc6\u5931\u8d25);
        }
    }

    public static String encryptByPrivateKey(String data, String privateKey) throws TechnologyException {
        return Base64.encodeBase64String((byte[])JRSAUtil.encryptByPrivateKey(data.getBytes(UTF_8), privateKey));
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws TechnologyException {
        return JRSAUtil.encryptByPrivateKey(data, Base64.decodeBase64((String)privateKey));
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] privateKey) throws TechnologyException {
        try {
            PrivateKey privateK = KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(privateKey));
            Cipher cipher = Cipher.getInstance(ALGORITHMS);
            cipher.init(1, privateK);
            return JRSAUtil.encryptAndDecryptOfSubsection(data, cipher, 117);
        }
        catch (Exception e) {
            throw new TechnologyException((Throwable)e, GeneralInternational.\u8bc1\u4e66\u52a0\u5bc6\u5931\u8d25);
        }
    }
}

