/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JSONUtils {
    private JSONUtils() {
    }

    public static boolean isJSON(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                JSONObject.parseObject((String)json);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String objectToJSON(Object obj) {
        if (Objects.nonNull(obj)) {
            return JSONObject.toJSONString((Object)obj);
        }
        return null;
    }

    public static byte[] objectToUTF8Bytes(Object obj) {
        String json = JSONUtils.objectToJSON(obj);
        return StringUtils.isNotBlank((CharSequence)json) ? json.getBytes(Charset.forName("UTF8")) : null;
    }

    public static String objectToUTF8Base64Code(Object obj) {
        byte[] jsonbytes = JSONUtils.objectToUTF8Bytes(obj);
        return Objects.nonNull(jsonbytes) ? Base64.encode(jsonbytes) : null;
    }

    public static String UTF8Base64CodeToJSON(String base64) {
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            try {
                return new String(Base64.decode(base64), Charset.forName("UTF8"));
            }
            catch (Base64DecodingException e) {
                System.err.println("\u6570\u636e\uff1a{" + base64 + "} \u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> T UTF8Base64CodeToObject(String base64, Class<T> clazz) {
        String json = JSONUtils.UTF8Base64CodeToJSON(base64);
        return StringUtils.isNotBlank((CharSequence)json) ? (T)JSONUtils.jsonToObject(json, clazz) : null;
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (T)JSONObject.parseObject((String)json, clazz);
            }
            catch (Exception e) {
                System.err.println("\u6570\u636e\uff1a{" + json + "} \u8f6c\u5bf9\u8c61\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> List<T> jsonToList(String json, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return JSONObject.parseArray((String)json, clazz);
            }
            catch (Exception e) {
                System.err.println("\u6570\u636e\uff1a" + json + " \u8f6c\u96c6\u5408\u5931\u8d25");
            }
        }
        return null;
    }

    public static <T> T objectToObject(Object obj, Class<T> clazz) {
        if (Objects.nonNull(obj)) {
            return JSONUtils.jsonToObject(JSONUtils.objectToJSON(obj), clazz);
        }
        return null;
    }

    public static <T> T objectToObjectNullBuild(Object obj, Class<T> clazz) {
        if (Objects.nonNull(obj)) {
            return JSONUtils.jsonToObject(JSONUtils.objectToJSON(obj), clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            assert (clazz != null);
            System.err.println("Class\uff1a" + clazz.getName() + " build fail");
            return null;
        }
    }

    public static <T> List<T> listToList(List list, Class<T> clazz) {
        if (Objects.nonNull(list) && !list.isEmpty()) {
            try {
                return JSONObject.parseArray((String)JSONUtils.objectToJSON(list), clazz);
            }
            catch (Exception e) {
                System.err.println("\u96c6\u5408\uff1a" + list + " \u8f6c\u96c6\u5408\u5931\u8d25");
            }
        }
        return null;
    }

    public static String parseObject(Object obj) {
        return JSONUtils.parseJSON(JSONUtils.objectToJSON(obj));
    }

    public static String parseJSON(String jsonData) {
        int level = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < jsonData.length(); ++i) {
            char c = jsonData.charAt(i);
            if (level > 0 && '\n' == stringBuffer.charAt(stringBuffer.length() - 1)) {
                stringBuffer.append(JSONUtils.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    stringBuffer.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    stringBuffer.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    stringBuffer.append("\n");
                    stringBuffer.append(JSONUtils.getLevelStr(--level));
                    stringBuffer.append(c);
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getLevelStr(int level) {
        StringBuffer levelStr = new StringBuffer();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("\t");
        }
        return levelStr.toString();
    }

    public static String getString(String json, String key, String defval) {
        try {
            String string = JSONObject.parseObject((String)json).getString(key);
            return StringUtils.isNotBlank((CharSequence)string) ? string : defval;
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
            return null;
        }
    }

    public static String getString(String json, String key) {
        return JSONUtils.getString(json, key, "");
    }

    public static Integer getInt(String json, String key, Integer defval) {
        try {
            Integer integer = JSONObject.parseObject((String)json).getInteger(key);
            return Objects.nonNull(integer) ? integer : defval;
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
            return null;
        }
    }

    public static Integer getInt(String json, String key) {
        return JSONUtils.getInt(json, key, 0);
    }

    public static Double getDouble(String json, String key, Double defval) {
        try {
            Double aDouble = JSONObject.parseObject((String)json).getDouble(key);
            return Objects.nonNull(aDouble) ? aDouble : defval;
        }
        catch (Exception e) {
            System.err.println("\u6570\u636e\uff1a{" + json + "} \u5e76\u975eJSON\u683c\u5f0f");
            return null;
        }
    }

    public static Double getDouble(String json, String key) {
        return JSONUtils.getDouble(json, key, 0.0);
    }
}

