/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListUtil.class);

    private ListUtil() {
    }

    public static List<String> getIntersection(List<String> list1, List<String> list2) {
        ArrayList<String> list3 = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String s : list1) {
            hashSet.add(s);
        }
        for (String s : list2) {
            if (hashSet.add(s)) continue;
            list3.add(s);
        }
        return list3;
    }

    public static List getDifferenceSet(List list1, List list2) {
        list1 = list1 == null ? new ArrayList() : new ArrayList(list1);
        if (list2 == null || list2.isEmpty()) {
            return list1;
        }
        list2 = new ArrayList(list2);
        list1.removeAll(list2);
        return list1;
    }

    public static <T> List<T> deepCopy(List<T> src) {
        List dest = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            dest = (List)in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dest;
    }

    public static List<Integer> idsChange(String idsString) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)idsString)) {
            throw new ProfessionalException("\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            String[] idsStr = idsString.split(",");
            if (idsStr != null && idsStr.length != 0) {
                for (String fid : idsStr) {
                    if (!StringUtils.isNotBlank((CharSequence)fid)) continue;
                    ids.add(Integer.parseInt(fid));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(idsString + "\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new ProfessionalException(idsString + "\u7f16\u53f7\u65e0\u6548");
        }
        return ids;
    }

    public static List<Integer> idsDistinctChange(String idsString) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)idsString)) {
            throw new ProfessionalException("\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> idStrings = new ArrayList<String>();
        String[] idsStr = idsString.split(",");
        if (idsStr != null && idsStr.length != 0) {
            for (String fid : idsStr) {
                if (!StringUtils.isNotBlank((CharSequence)fid) || idStrings.contains(fid)) continue;
                idStrings.add(fid);
            }
        }
        List<Integer> ids = null;
        try {
            ids = JSONUtils.jsonToList(JSONUtils.objectToJSON(idStrings), Integer.class);
        }
        catch (Exception e) {
            LOGGER.error(idsString + "\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new ProfessionalException(idsString + "\u7f16\u53f7\u65e0\u6548");
        }
        return ids;
    }

    public static List<Date> datesChange(String dates, boolean type) throws GeneralException {
        if (StringUtils.isBlank((CharSequence)dates)) {
            throw new ProfessionalException("\u65f6\u95f4\u5b57\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Date> dateList = new ArrayList<Date>();
        if (type) {
            List<String> datesString = Arrays.asList(dates.split(","));
            if (datesString != null && !datesString.isEmpty()) {
                for (String s : datesString) {
                    dateList.add(DateUtils.getDateTime(s, "yyyyMMdd"));
                }
            }
        } else {
            List<String> datesString = Arrays.asList(dates.split("-"));
            if (datesString == null || datesString.isEmpty() || datesString.size() != 2) {
                throw new ProfessionalException("\u7ed9\u5b9a\u65f6\u95f4\u533a\u95f4\u4e0d\u6b63\u786e[" + dates + "]");
            }
            Date dateStart = DateUtils.getDateTime(datesString.get(0), "yyyyMMdd");
            Date dateEnd = DateUtils.getDateTime(datesString.get(1), "yyyyMMdd");
            dateList = DateUtils.getMonthBetweenDate(dateStart, dateEnd);
        }
        return dateList;
    }

    public static List<String> mobilesChange(String mobiles) throws ProfessionalException {
        if (StringUtils.isBlank((CharSequence)mobiles)) {
            throw new ProfessionalException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Arrays.asList(mobiles.split(","));
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remaider = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remaider > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remaider;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    public static <E> void sort(List<E> list, final boolean isAsc, final String ... sortNameArr) {
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < sortNameArr.length && 0 == (ret = ListUtil.compareObject(sortNameArr[i], isAsc, a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
    }

    private static <E> int compareObject(String sortname, boolean isAsc, E a, E b) throws Exception {
        Object value1 = ListUtil.forceGetFieldValue(a, sortname);
        Object value2 = ListUtil.forceGetFieldValue(b, sortname);
        String str1 = value1.toString();
        String str2 = value2.toString();
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = ListUtil.addZero2Str((Number)value1, maxlen);
            str2 = ListUtil.addZero2Str((Number)value2, maxlen);
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = ListUtil.addZero2Str(time1, maxlen);
            str2 = ListUtil.addZero2Str(time2, maxlen);
        }
        int ret = isAsc ? str1.compareTo(str2) : str2.compareTo(str1);
        return ret;
    }

    public static String addZero2Str(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    public static Object forceGetFieldValue(Object obj, String fieldName) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        Object object = null;
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
            object = field.get(obj);
            field.setAccessible(accessible);
            return object;
        }
        object = field.get(obj);
        return object;
    }
}

