/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import java.time.YearMonth;

public class LongKidUtils {
    private static final long TWEPOCH = 1420041600000L;
    private static final long WORKERIDBITS = 5L;
    private static final long DATACENTERIDBITS = 5L;
    private static final long MAXWORKERID = 31L;
    private static final long MAXDATACENTERID = 31L;
    private static final long SEQUENCEBITS = 12L;
    private static final long WORKERIDSHIFT = 12L;
    private static final long DATACENTERIDSHIFT = 17L;
    private static final long TIMESTAMPLEFTSHIFT = 22L;
    private static final long SEQUENCEMASK = 4095L;
    private static long WORKERID = 29L;
    private static long DATACENTERID = 24L;
    private static long SEQUENCE = 0L;
    private static long LASTTIMESTAMP = -1L;

    private LongKidUtils() {
    }

    public static synchronized long nextId() {
        long timestamp = LongKidUtils.timeGen();
        if (timestamp < LASTTIMESTAMP) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", LASTTIMESTAMP - timestamp));
        }
        if (LASTTIMESTAMP == timestamp) {
            if ((SEQUENCE = SEQUENCE + 1L & 0xFFFL) == 0L) {
                timestamp = LongKidUtils.tilNextMillis(LASTTIMESTAMP);
            }
        } else {
            SEQUENCE = 0L;
        }
        LASTTIMESTAMP = timestamp;
        Long Id = timestamp - 1420041600000L << 22 | DATACENTERID << 17 | WORKERID << 12 | SEQUENCE;
        return Long.parseLong(YearMonth.now().toString().replace("-", "") + Id.toString().substring(5, Id.toString().length()));
    }

    public static synchronized String nextIdStr() {
        long timestamp = LongKidUtils.timeGen();
        if (timestamp < LASTTIMESTAMP) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", LASTTIMESTAMP - timestamp));
        }
        if (LASTTIMESTAMP == timestamp) {
            if ((SEQUENCE = SEQUENCE + 1L & 0xFFFL) == 0L) {
                timestamp = LongKidUtils.tilNextMillis(LASTTIMESTAMP);
            }
        } else {
            SEQUENCE = 0L;
        }
        LASTTIMESTAMP = timestamp;
        Long Id = timestamp - 1420041600000L << 22 | DATACENTERID << 17 | WORKERID << 12 | SEQUENCE;
        return YearMonth.now().toString().replace("-", "") + Id.toString().substring(5, Id.toString().length());
    }

    protected static long tilNextMillis(long lastTimestamp) {
        long timestamp = LongKidUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = LongKidUtils.timeGen();
        }
        return timestamp;
    }

    protected static long timeGen() {
        return System.currentTimeMillis();
    }
}

