/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.common.utils.JSONUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MD5Utils {
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private MD5Utils() {
    }

    public static String stringToMD5(String plainText) {
        byte[] secretBytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            secretBytes = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u6ca1\u6709md5\u8fd9\u4e2a\u7b97\u6cd5\uff01");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); ++i) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    public static String str2MD5(String plainText) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(plainText.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException var7) {
            throw new RuntimeException("MD5 should be supported?", var7);
        }
        catch (UnsupportedEncodingException var8) {
            throw new RuntimeException("UTF-8 should be supported?", var8);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        byte[] var6 = hash;
        int var5 = hash.length;
        for (int var4 = 0; var4 < var5; ++var4) {
            byte b = var6[var4];
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String convertMD5(String inStr) {
        char[] a = inStr.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = (char)(a[i] ^ 0x74);
        }
        return new String(a);
    }

    public static String string2MD5(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        char[] charArray = inStr.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String md5(File file) {
        try {
            MessageDigest msgDigest = null;
            try {
                msgDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("System doesn't support MD5 algorithm.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] bs = new byte[1024];
            while (fileInputStream.read(bs) != -1) {
                msgDigest.update(bs);
            }
            byte[] bytes = msgDigest.digest();
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            return MD5Utils.byteToString(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String byteToString(byte[] bytes) {
        String md5Str = "";
        for (int i = 0; i < bytes.length; ++i) {
            byte tb = bytes[i];
            char tmpChar = (char)(tb >>> 4 & 0xF);
            char high = tmpChar >= '\n' ? (char)(97 + tmpChar - 10) : (char)(48 + tmpChar);
            md5Str = md5Str + high;
            tmpChar = (char)(tb & 0xF);
            char low = tmpChar >= '\n' ? (char)(97 + tmpChar - 10) : (char)(48 + tmpChar);
            md5Str = md5Str + low;
        }
        return md5Str;
    }

    public static String md5(byte[] bs) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        msgDigest.update(bs);
        byte[] bytes = msgDigest.digest();
        return MD5Utils.byteToString(bytes);
    }

    public static byte[] md5Byte(String str) {
        try {
            byte[] utfBytes = str.getBytes("UTF-8");
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(utfBytes);
            return mdTemp.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace();
            return null;
        }
    }

    public static String MD5Encode(String origin, String charsetname) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = charsetname == null || "".equals(charsetname) ? MD5Utils.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Utils.byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultString;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Utils.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String bulidSourceSignature(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            ArrayList list = new ArrayList();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String str;
                    String val = k + "=";
                    val = v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long ? val + v + "&" : (v instanceof Date ? val + DateUtils.getString((Date)v) + "&" : (v instanceof BigDecimal ? val + ((BigDecimal)v).doubleValue() + "&" : (v instanceof com.jhscale.common.model.simple.JSONModel ? val + ((com.jhscale.common.model.simple.JSONModel)v).toJSON() + "&" : (v instanceof List || v instanceof Map ? val + JSONUtils.objectToJSON(v) + "&" : ((str = v.toString()).contains("@") ? val + JSONUtils.objectToJSON(v) + "&" : val + str + "&")))));
                    list.add(val);
                }
            });
            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            return result;
        }
        return "";
    }

    public static String bulidSourceSignature_date(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            ArrayList list = new ArrayList();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String str;
                    String val = k + "=";
                    val = v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long ? val + v + "&" : (v instanceof Date ? val + DateUtils.getString((Date)v) + "&" : (v instanceof BigDecimal ? val + ((BigDecimal)v).doubleValue() + "&" : (v instanceof com.jhscale.common.model.simple.JSONModel ? val + ((com.jhscale.common.model.simple.JSONModel)v).toJSON() + "&" : (v instanceof List || v instanceof Map ? val + JSONUtils.objectToJSON(v) + "&" : ((str = v.toString()).contains("@") ? val + JSONUtils.objectToJSON(v) + "&" : val + str + "&")))));
                    list.add(val);
                }
            });
            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            return result;
        }
        return "";
    }

    public static String bulidSourceSignature_ad(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            ArrayList list = new ArrayList();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String str;
                    String val = k + "=";
                    val = v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long ? val + v + "&" : (v instanceof Date ? val + DateUtils.getString((Date)v) + "&" : (v instanceof BigDecimal ? val + ((BigDecimal)v).doubleValue() + "&" : (v instanceof GJSONModel ? val + ((GJSONModel)v).toJSON() + "&" : (v instanceof com.jhscale.common.model.simple.JSONModel || v instanceof JSONModel ? val + GJSONUtils.objectToJSON(v) + "&" : (v instanceof List || v instanceof Map ? val + GJSONUtils.objectToJSON(v) + "&" : ((str = v.toString()).contains("@") ? val + GJSONUtils.objectToJSON(v) + "&" : val + str + "&"))))));
                    list.add(val);
                }
            });
            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            return result;
        }
        return "";
    }

    public static String bulidMD5Signature(String result) {
        return MD5Utils.str2MD5(result).toUpperCase();
    }

    public static String bulidMD5Signature(Map map, String key) {
        return MD5Utils.bulidMD5Signature(MD5Utils.bulidSourceSignature(map, key));
    }

    public static String bulidMD5Signature_ad(Map map, String key) {
        return MD5Utils.bulidMD5Signature(MD5Utils.bulidSourceSignature_ad(map, key));
    }
}

