/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

public class MathUtils {
    private MathUtils() {
    }

    public static float average(float[] a) {
        return MathUtils.sum(a) / (float)a.length;
    }

    public static float sum(float[] a) {
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static float[] normalize(float[] a) {
        float sum = MathUtils.sum(a);
        if (sum == 0.0f) {
            return a;
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] / sum;
        }
        return a;
    }

    public static float[] calculateColumnAverages(float[][] array) {
        int numRows = array.length;
        int numCols = array[0].length;
        float[] averages = new float[numCols];
        for (int j = 0; j < numCols; ++j) {
            float sum = 0.0f;
            for (int i = 0; i < numRows; ++i) {
                sum += array[i][j];
            }
            averages[j] = sum / (float)numRows;
        }
        return averages;
    }

    public static float[] calculateColumnAverages(float[] target, int weight, float[] source) {
        float[] result = null;
        if (target == null) {
            result = source;
        } else {
            int length = Math.max(target.length, source.length);
            result = new float[length];
            for (int i = 0; i < length; ++i) {
                float x = 0.0f;
                try {
                    x = target[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float y = 0.0f;
                try {
                    y = source[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result[i] = (x * (float)weight + y) / (float)(weight + 1);
            }
        }
        return result;
    }

    public static float[] calculateColumnAverages(float[] target, int target_weight, float[] source, int source_weight) {
        float[] result = null;
        if (target == null) {
            result = source;
        } else {
            int length = Math.max(target.length, source.length);
            result = new float[length];
            for (int i = 0; i < length; ++i) {
                float x = 0.0f;
                try {
                    x = target[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float y = 0.0f;
                try {
                    y = source[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result[i] = (x * (float)target_weight - y * (float)source_weight) / (float)(target_weight - source_weight);
            }
        }
        return result;
    }

    public static float calculate0(float[] vector1, float[] vector2) {
        float sum = 0.0f;
        for (int i = 0; i < vector1.length; ++i) {
            sum = (float)((double)sum + Math.pow(vector1[i] - vector2[i], 2.0));
        }
        return (float)Math.sqrt(sum);
    }

    public static float calculate1(float[] vector1, float[] vector2) {
        float sum = 0.0f;
        for (int i = 0; i < vector1.length; ++i) {
            sum += Math.abs(vector1[i] - vector2[i]);
        }
        return sum;
    }

    public static float calculate2(float[] vector1, float[] vector2) {
        float max = 0.0f;
        for (int i = 0; i < vector1.length; ++i) {
            float diff = Math.abs(vector1[i] - vector2[i]);
            if (!(diff > max)) continue;
            max = diff;
        }
        return max;
    }

    public static float calculate3(float[] vector1, float[] vector2) {
        float dotProduct = 0.0f;
        float normA = 0.0f;
        float normB = 0.0f;
        for (int i = 0; i < vector1.length; ++i) {
            dotProduct += vector1[i] * vector2[i];
            normA = (float)((double)normA + Math.pow(vector1[i], 2.0));
            normB = (float)((double)normB + Math.pow(vector2[i], 2.0));
        }
        return dotProduct / (float)(Math.sqrt(normA) * Math.sqrt(normB));
    }

    public static float calculate31(float[] feature) {
        float norm = 0.0f;
        for (int i = 0; i < feature.length; ++i) {
            norm += feature[i] * feature[i];
        }
        return norm;
    }

    public static float calculate4(float[] vector1, float[] vector2) {
        float mean1 = MathUtils.average(vector1);
        float mean2 = MathUtils.average(vector2);
        float sumXY = 0.0f;
        float sumX = 0.0f;
        float sumY = 0.0f;
        float sumXSquare = 0.0f;
        float sumYSquare = 0.0f;
        int n = vector1.length;
        for (int i = 0; i < n; ++i) {
            sumXY += (vector1[i] - mean1) * (vector2[i] - mean2);
            sumX += vector1[i];
            sumY += vector2[i];
            sumXSquare = (float)((double)sumXSquare + Math.pow(vector1[i], 2.0));
            sumYSquare = (float)((double)sumYSquare + Math.pow(vector2[i], 2.0));
        }
        return ((float)n * sumXY - sumX * sumY) / (float)Math.sqrt(((double)((float)n * sumXSquare) - Math.pow(sumX, 2.0)) * ((double)((float)n * sumYSquare) - Math.pow(sumY, 2.0)));
    }
}

