/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.utils;

import com.jhscale.common.utils.FileUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private PictureUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(BufferedImage source, String formatName, File file) {
        Iterator<ImageWriter> iter;
        if (StringUtils.isNotBlank((CharSequence)formatName) && file != null && !file.isDirectory() && (iter = ImageIO.getImageWritersByFormatName(formatName)).hasNext()) {
            ImageWriter writer = iter.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            FileImageOutputStream out = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new FileImageOutputStream(file);
                writer.setOutput(out);
                writer.write(null, new IIOImage(source, null, null), param);
                writer.dispose();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                System.err.println("BufferedImage Write \u5f02\u5e38");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    public static int size(BufferedImage image, String type) {
        return PictureUtils.image2InputStream(image, type).getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImageInputStream image2InputStream(BufferedImage image, String type) {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, type, bos);
            BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream(new ByteArrayInputStream(bos.toByteArray()), bos.size());
            return bufferedImageInputStream;
        }
        catch (IOException e) {
            LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            BufferedImageInputStream bufferedImageInputStream = new BufferedImageInputStream(-1);
            return bufferedImageInputStream;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BufferedImage compress(BufferedImage source, double ratio) {
        return PictureUtils.compress(source, 0, 0, ratio);
    }

    public static BufferedImage compress(BufferedImage source, int width, int height) {
        return PictureUtils.compress(source, width, height, 0.0);
    }

    public static BufferedImage compress(BufferedImage source, int width, int height, double rate) {
        if (rate > 0.0) {
            width = (int)((double)source.getWidth() * rate);
            height = (int)((double)source.getHeight() * rate);
        }
        BufferedImage target = new BufferedImage(width, height, source.getType());
        Graphics graphics = target.getGraphics();
        graphics.drawImage(source.getScaledInstance(width, height, 4), 0, 0, null);
        graphics.dispose();
        return target;
    }

    public static BufferedImage rotate(BufferedImage source, int angel) {
        Rectangle rect_des = PictureUtils.CalcRotatedSize(new Rectangle(new Dimension(source.getWidth(), source.getHeight())), angel);
        BufferedImage targetImage = new BufferedImage(rect_des.width, rect_des.height, 1);
        Graphics2D g2 = targetImage.createGraphics();
        g2.translate((rect_des.width - source.getWidth()) / 2, (rect_des.height - source.getHeight()) / 2);
        g2.rotate(Math.toRadians(angel), source.getWidth() / 2, source.getHeight() / 2);
        g2.drawImage(source, null, null);
        return targetImage;
    }

    public static BufferedImage cut(BufferedImage source, int x, int y, int width, int height) {
        return source.getSubimage(x, y, width, height);
    }

    public static BufferedImage water_mark_position(BufferedImage source, String text, int position) {
        int width = source.getWidth();
        int height = source.getHeight();
        String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
        int FONT_STYLE = 1;
        int FONT_SIZE = (width + height) / 40;
        Color FONT_COLOR = Color.black;
        float ALPHA = 0.3f;
        float ROTATE = 0.0f;
        BufferedImage target = new BufferedImage(width, height, source.getType());
        Graphics2D graphics = target.createGraphics();
        graphics.drawImage(source, 0, 0, width, height, null);
        graphics.setColor(FONT_COLOR);
        graphics.setFont(new Font(FONT_NAME, FONT_STYLE, FONT_SIZE));
        graphics.setComposite(AlphaComposite.getInstance(10, ALPHA));
        graphics.rotate(ROTATE);
        switch (position) {
            case 0: {
                graphics.drawString(text, 0, FONT_SIZE);
                break;
            }
            case 1: {
                graphics.drawString(text, width - PictureUtils.textWidth(text, FONT_SIZE), FONT_SIZE);
                break;
            }
            case 2: {
                graphics.drawString(text, 0, height);
                break;
            }
            case 3: {
                graphics.drawString(text, width - PictureUtils.textWidth(text, FONT_SIZE), height);
            }
        }
        graphics.dispose();
        return target;
    }

    public static BufferedImage water_mark_oblique(BufferedImage source, String text, float rotate) {
        int width = source.getWidth();
        int height = source.getHeight();
        String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
        int FONT_STYLE = 1;
        int FONT_SIZE = (width + height) / 40;
        Color FONT_COLOR = Color.black;
        float ALPHA = 0.3f;
        float ROTATE = rotate;
        BufferedImage target = new BufferedImage(width, height, source.getType());
        Graphics2D graphics = target.createGraphics();
        graphics.drawImage(source, 0, 0, width, height, null);
        graphics.setColor(FONT_COLOR);
        graphics.setFont(new Font(FONT_NAME, FONT_STYLE, FONT_SIZE));
        graphics.setComposite(AlphaComposite.getInstance(10, ALPHA));
        graphics.rotate(ROTATE);
        int split = FONT_SIZE * 2;
        int xWidth = PictureUtils.textWidth(text, FONT_SIZE);
        int xCanNum = width / xWidth + 1;
        int yCanNum = height / FONT_SIZE + 1;
        for (int i = 1; i <= yCanNum; ++i) {
            int y = FONT_SIZE * i + split * i;
            for (int j = 0; j < xCanNum; ++j) {
                int x = xWidth * j + split * j;
                graphics.drawString(text, x, y - (FONT_SIZE + split) * j);
            }
        }
        return target;
    }

    private static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    private static int textWidth(String text, int fontSize) {
        char[] chars = text.toCharArray();
        fontSize = fontSize % 2 == 0 ? fontSize : fontSize + 1;
        int fontSize2 = fontSize / 2 + 3;
        int width = 0;
        for (char c : chars) {
            int len = String.valueOf(c).getBytes().length;
            if (len != 1) {
                width += fontSize;
                continue;
            }
            width += fontSize2;
        }
        return width;
    }

    public static class BufferedImageInputStream {
        private InputStream inputStream;
        private int length;

        public BufferedImageInputStream() {
        }

        public BufferedImageInputStream(InputStream inputStream, int length) {
            this.inputStream = inputStream;
            this.length = length;
        }

        public BufferedImageInputStream(int length) {
            this.length = length;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }
}

